// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The VirtualNetworkGatewayAutoScaleBounds model.
 */
@Fluent
public final class VirtualNetworkGatewayAutoScaleBounds
    implements JsonSerializable<VirtualNetworkGatewayAutoScaleBounds> {
    /*
     * Minimum scale Units for Autoscale configuration
     */
    private Integer min;

    /*
     * Maximum Scale Units for Autoscale configuration
     */
    private Integer max;

    /**
     * Creates an instance of VirtualNetworkGatewayAutoScaleBounds class.
     */
    public VirtualNetworkGatewayAutoScaleBounds() {
    }

    /**
     * Get the min property: Minimum scale Units for Autoscale configuration.
     * 
     * @return the min value.
     */
    public Integer min() {
        return this.min;
    }

    /**
     * Set the min property: Minimum scale Units for Autoscale configuration.
     * 
     * @param min the min value to set.
     * @return the VirtualNetworkGatewayAutoScaleBounds object itself.
     */
    public VirtualNetworkGatewayAutoScaleBounds withMin(Integer min) {
        this.min = min;
        return this;
    }

    /**
     * Get the max property: Maximum Scale Units for Autoscale configuration.
     * 
     * @return the max value.
     */
    public Integer max() {
        return this.max;
    }

    /**
     * Set the max property: Maximum Scale Units for Autoscale configuration.
     * 
     * @param max the max value to set.
     * @return the VirtualNetworkGatewayAutoScaleBounds object itself.
     */
    public VirtualNetworkGatewayAutoScaleBounds withMax(Integer max) {
        this.max = max;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("min", this.min);
        jsonWriter.writeNumberField("max", this.max);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkGatewayAutoScaleBounds from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkGatewayAutoScaleBounds if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkGatewayAutoScaleBounds.
     */
    public static VirtualNetworkGatewayAutoScaleBounds fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkGatewayAutoScaleBounds deserializedVirtualNetworkGatewayAutoScaleBounds
                = new VirtualNetworkGatewayAutoScaleBounds();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("min".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayAutoScaleBounds.min = reader.getNullable(JsonReader::getInt);
                } else if ("max".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayAutoScaleBounds.max = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkGatewayAutoScaleBounds;
        });
    }
}
