// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Network Virtual Appliance Sku Properties.
 */
@Fluent
public final class VirtualApplianceSkuProperties implements JsonSerializable<VirtualApplianceSkuProperties> {
    /*
     * Virtual Appliance Vendor.
     */
    private String vendor;

    /*
     * Virtual Appliance Scale Unit.
     */
    private String bundledScaleUnit;

    /*
     * Virtual Appliance Version.
     */
    private String marketPlaceVersion;

    /**
     * Creates an instance of VirtualApplianceSkuProperties class.
     */
    public VirtualApplianceSkuProperties() {
    }

    /**
     * Get the vendor property: Virtual Appliance Vendor.
     * 
     * @return the vendor value.
     */
    public String vendor() {
        return this.vendor;
    }

    /**
     * Set the vendor property: Virtual Appliance Vendor.
     * 
     * @param vendor the vendor value to set.
     * @return the VirtualApplianceSkuProperties object itself.
     */
    public VirtualApplianceSkuProperties withVendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    /**
     * Get the bundledScaleUnit property: Virtual Appliance Scale Unit.
     * 
     * @return the bundledScaleUnit value.
     */
    public String bundledScaleUnit() {
        return this.bundledScaleUnit;
    }

    /**
     * Set the bundledScaleUnit property: Virtual Appliance Scale Unit.
     * 
     * @param bundledScaleUnit the bundledScaleUnit value to set.
     * @return the VirtualApplianceSkuProperties object itself.
     */
    public VirtualApplianceSkuProperties withBundledScaleUnit(String bundledScaleUnit) {
        this.bundledScaleUnit = bundledScaleUnit;
        return this;
    }

    /**
     * Get the marketPlaceVersion property: Virtual Appliance Version.
     * 
     * @return the marketPlaceVersion value.
     */
    public String marketPlaceVersion() {
        return this.marketPlaceVersion;
    }

    /**
     * Set the marketPlaceVersion property: Virtual Appliance Version.
     * 
     * @param marketPlaceVersion the marketPlaceVersion value to set.
     * @return the VirtualApplianceSkuProperties object itself.
     */
    public VirtualApplianceSkuProperties withMarketPlaceVersion(String marketPlaceVersion) {
        this.marketPlaceVersion = marketPlaceVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vendor", this.vendor);
        jsonWriter.writeStringField("bundledScaleUnit", this.bundledScaleUnit);
        jsonWriter.writeStringField("marketPlaceVersion", this.marketPlaceVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualApplianceSkuProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualApplianceSkuProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualApplianceSkuProperties.
     */
    public static VirtualApplianceSkuProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualApplianceSkuProperties deserializedVirtualApplianceSkuProperties
                = new VirtualApplianceSkuProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vendor".equals(fieldName)) {
                    deserializedVirtualApplianceSkuProperties.vendor = reader.getString();
                } else if ("bundledScaleUnit".equals(fieldName)) {
                    deserializedVirtualApplianceSkuProperties.bundledScaleUnit = reader.getString();
                } else if ("marketPlaceVersion".equals(fieldName)) {
                    deserializedVirtualApplianceSkuProperties.marketPlaceVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualApplianceSkuProperties;
        });
    }
}
