// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * List of session IDs.
 */
@Fluent
public final class SessionIds implements JsonSerializable<SessionIds> {
    /*
     * List of session IDs.
     */
    private List<String> sessionIds;

    /**
     * Creates an instance of SessionIds class.
     */
    public SessionIds() {
    }

    /**
     * Get the sessionIds property: List of session IDs.
     * 
     * @return the sessionIds value.
     */
    public List<String> sessionIds() {
        return this.sessionIds;
    }

    /**
     * Set the sessionIds property: List of session IDs.
     * 
     * @param sessionIds the sessionIds value to set.
     * @return the SessionIds object itself.
     */
    public SessionIds withSessionIds(List<String> sessionIds) {
        this.sessionIds = sessionIds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("sessionIds", this.sessionIds, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SessionIds from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SessionIds if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the SessionIds.
     */
    public static SessionIds fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SessionIds deserializedSessionIds = new SessionIds();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sessionIds".equals(fieldName)) {
                    List<String> sessionIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedSessionIds.sessionIds = sessionIds;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSessionIds;
        });
    }
}
