// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Route destination.
 */
@Fluent
public final class RoutingRuleRouteDestination implements JsonSerializable<RoutingRuleRouteDestination> {
    /*
     * Destination type.
     */
    private RoutingRuleDestinationType type;

    /*
     * Destination address.
     */
    private String destinationAddress;

    /**
     * Creates an instance of RoutingRuleRouteDestination class.
     */
    public RoutingRuleRouteDestination() {
    }

    /**
     * Get the type property: Destination type.
     * 
     * @return the type value.
     */
    public RoutingRuleDestinationType type() {
        return this.type;
    }

    /**
     * Set the type property: Destination type.
     * 
     * @param type the type value to set.
     * @return the RoutingRuleRouteDestination object itself.
     */
    public RoutingRuleRouteDestination withType(RoutingRuleDestinationType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the destinationAddress property: Destination address.
     * 
     * @return the destinationAddress value.
     */
    public String destinationAddress() {
        return this.destinationAddress;
    }

    /**
     * Set the destinationAddress property: Destination address.
     * 
     * @param destinationAddress the destinationAddress value to set.
     * @return the RoutingRuleRouteDestination object itself.
     */
    public RoutingRuleRouteDestination withDestinationAddress(String destinationAddress) {
        this.destinationAddress = destinationAddress;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property type in model RoutingRuleRouteDestination"));
        }
        if (destinationAddress() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property destinationAddress in model RoutingRuleRouteDestination"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RoutingRuleRouteDestination.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("destinationAddress", this.destinationAddress);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoutingRuleRouteDestination from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoutingRuleRouteDestination if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RoutingRuleRouteDestination.
     */
    public static RoutingRuleRouteDestination fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoutingRuleRouteDestination deserializedRoutingRuleRouteDestination = new RoutingRuleRouteDestination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedRoutingRuleRouteDestination.type
                        = RoutingRuleDestinationType.fromString(reader.getString());
                } else if ("destinationAddress".equals(fieldName)) {
                    deserializedRoutingRuleRouteDestination.destinationAddress = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoutingRuleRouteDestination;
        });
    }
}
