// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Next hop.
 */
@Fluent
public final class RoutingRuleNextHop implements JsonSerializable<RoutingRuleNextHop> {
    /*
     * Next hop type.
     */
    private RoutingRuleNextHopType nextHopType;

    /*
     * Next hop address. Only required if the next hop type is VirtualAppliance.
     */
    private String nextHopAddress;

    /**
     * Creates an instance of RoutingRuleNextHop class.
     */
    public RoutingRuleNextHop() {
    }

    /**
     * Get the nextHopType property: Next hop type.
     * 
     * @return the nextHopType value.
     */
    public RoutingRuleNextHopType nextHopType() {
        return this.nextHopType;
    }

    /**
     * Set the nextHopType property: Next hop type.
     * 
     * @param nextHopType the nextHopType value to set.
     * @return the RoutingRuleNextHop object itself.
     */
    public RoutingRuleNextHop withNextHopType(RoutingRuleNextHopType nextHopType) {
        this.nextHopType = nextHopType;
        return this;
    }

    /**
     * Get the nextHopAddress property: Next hop address. Only required if the next hop type is VirtualAppliance.
     * 
     * @return the nextHopAddress value.
     */
    public String nextHopAddress() {
        return this.nextHopAddress;
    }

    /**
     * Set the nextHopAddress property: Next hop address. Only required if the next hop type is VirtualAppliance.
     * 
     * @param nextHopAddress the nextHopAddress value to set.
     * @return the RoutingRuleNextHop object itself.
     */
    public RoutingRuleNextHop withNextHopAddress(String nextHopAddress) {
        this.nextHopAddress = nextHopAddress;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (nextHopType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property nextHopType in model RoutingRuleNextHop"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RoutingRuleNextHop.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextHopType", this.nextHopType == null ? null : this.nextHopType.toString());
        jsonWriter.writeStringField("nextHopAddress", this.nextHopAddress);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoutingRuleNextHop from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoutingRuleNextHop if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RoutingRuleNextHop.
     */
    public static RoutingRuleNextHop fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoutingRuleNextHop deserializedRoutingRuleNextHop = new RoutingRuleNextHop();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nextHopType".equals(fieldName)) {
                    deserializedRoutingRuleNextHop.nextHopType = RoutingRuleNextHopType.fromString(reader.getString());
                } else if ("nextHopAddress".equals(fieldName)) {
                    deserializedRoutingRuleNextHop.nextHopAddress = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoutingRuleNextHop;
        });
    }
}
