// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.RoutingRuleInner;
import java.io.IOException;
import java.util.List;

/**
 * Routing configuration rule list result.
 */
@Fluent
public final class RoutingRuleListResult implements JsonSerializable<RoutingRuleListResult> {
    /*
     * A list of routing rules.
     */
    private List<RoutingRuleInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of RoutingRuleListResult class.
     */
    public RoutingRuleListResult() {
    }

    /**
     * Get the value property: A list of routing rules.
     * 
     * @return the value value.
     */
    public List<RoutingRuleInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of routing rules.
     * 
     * @param value the value value to set.
     * @return the RoutingRuleListResult object itself.
     */
    public RoutingRuleListResult withValue(List<RoutingRuleInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the RoutingRuleListResult object itself.
     */
    public RoutingRuleListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoutingRuleListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoutingRuleListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoutingRuleListResult.
     */
    public static RoutingRuleListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoutingRuleListResult deserializedRoutingRuleListResult = new RoutingRuleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RoutingRuleInner> value = reader.readArray(reader1 -> RoutingRuleInner.fromJson(reader1));
                    deserializedRoutingRuleListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedRoutingRuleListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoutingRuleListResult;
        });
    }
}
