// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Property to indicate if the Express Route Gateway has resiliency model of MultiHomed or SingleHomed.
 */
public final class ResiliencyModel extends ExpandableStringEnum<ResiliencyModel> {
    /**
     * Static value SingleHomed for ResiliencyModel.
     */
    public static final ResiliencyModel SINGLE_HOMED = fromString("SingleHomed");

    /**
     * Static value MultiHomed for ResiliencyModel.
     */
    public static final ResiliencyModel MULTI_HOMED = fromString("MultiHomed");

    /**
     * Creates a new instance of ResiliencyModel value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ResiliencyModel() {
    }

    /**
     * Creates or finds a ResiliencyModel from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ResiliencyModel.
     */
    public static ResiliencyModel fromString(String name) {
        return fromString(name, ResiliencyModel.class);
    }

    /**
     * Gets known ResiliencyModel values.
     * 
     * @return known ResiliencyModel values.
     */
    public static Collection<ResiliencyModel> values() {
        return values(ResiliencyModel.class);
    }
}
