// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A collective group of information about the record set information.
 */
@Fluent
public final class RecordSet implements JsonSerializable<RecordSet> {
    /*
     * Resource record type.
     */
    private String recordType;

    /*
     * Recordset name.
     */
    private String recordSetName;

    /*
     * Fqdn that resolves to private endpoint ip address.
     */
    private String fqdn;

    /*
     * The provisioning state of the recordset.
     */
    private ProvisioningState provisioningState;

    /*
     * Recordset time to live.
     */
    private Integer ttl;

    /*
     * The private ip address of the private endpoint.
     */
    private List<String> ipAddresses;

    /**
     * Creates an instance of RecordSet class.
     */
    public RecordSet() {
    }

    /**
     * Get the recordType property: Resource record type.
     * 
     * @return the recordType value.
     */
    public String recordType() {
        return this.recordType;
    }

    /**
     * Set the recordType property: Resource record type.
     * 
     * @param recordType the recordType value to set.
     * @return the RecordSet object itself.
     */
    public RecordSet withRecordType(String recordType) {
        this.recordType = recordType;
        return this;
    }

    /**
     * Get the recordSetName property: Recordset name.
     * 
     * @return the recordSetName value.
     */
    public String recordSetName() {
        return this.recordSetName;
    }

    /**
     * Set the recordSetName property: Recordset name.
     * 
     * @param recordSetName the recordSetName value to set.
     * @return the RecordSet object itself.
     */
    public RecordSet withRecordSetName(String recordSetName) {
        this.recordSetName = recordSetName;
        return this;
    }

    /**
     * Get the fqdn property: Fqdn that resolves to private endpoint ip address.
     * 
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Set the fqdn property: Fqdn that resolves to private endpoint ip address.
     * 
     * @param fqdn the fqdn value to set.
     * @return the RecordSet object itself.
     */
    public RecordSet withFqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the recordset.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the ttl property: Recordset time to live.
     * 
     * @return the ttl value.
     */
    public Integer ttl() {
        return this.ttl;
    }

    /**
     * Set the ttl property: Recordset time to live.
     * 
     * @param ttl the ttl value to set.
     * @return the RecordSet object itself.
     */
    public RecordSet withTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    /**
     * Get the ipAddresses property: The private ip address of the private endpoint.
     * 
     * @return the ipAddresses value.
     */
    public List<String> ipAddresses() {
        return this.ipAddresses;
    }

    /**
     * Set the ipAddresses property: The private ip address of the private endpoint.
     * 
     * @param ipAddresses the ipAddresses value to set.
     * @return the RecordSet object itself.
     */
    public RecordSet withIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recordType", this.recordType);
        jsonWriter.writeStringField("recordSetName", this.recordSetName);
        jsonWriter.writeStringField("fqdn", this.fqdn);
        jsonWriter.writeNumberField("ttl", this.ttl);
        jsonWriter.writeArrayField("ipAddresses", this.ipAddresses, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecordSet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecordSet if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the RecordSet.
     */
    public static RecordSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecordSet deserializedRecordSet = new RecordSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("recordType".equals(fieldName)) {
                    deserializedRecordSet.recordType = reader.getString();
                } else if ("recordSetName".equals(fieldName)) {
                    deserializedRecordSet.recordSetName = reader.getString();
                } else if ("fqdn".equals(fieldName)) {
                    deserializedRecordSet.fqdn = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedRecordSet.provisioningState = ProvisioningState.fromString(reader.getString());
                } else if ("ttl".equals(fieldName)) {
                    deserializedRecordSet.ttl = reader.getNullable(JsonReader::getInt);
                } else if ("ipAddresses".equals(fieldName)) {
                    List<String> ipAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedRecordSet.ipAddresses = ipAddresses;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecordSet;
        });
    }
}
