// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.PrivateDnsZoneGroupInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for the ListPrivateDnsZoneGroups API service call.
 */
@Fluent
public final class PrivateDnsZoneGroupListResult implements JsonSerializable<PrivateDnsZoneGroupListResult> {
    /*
     * A list of private dns zone group resources in a private endpoint.
     */
    private List<PrivateDnsZoneGroupInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of PrivateDnsZoneGroupListResult class.
     */
    public PrivateDnsZoneGroupListResult() {
    }

    /**
     * Get the value property: A list of private dns zone group resources in a private endpoint.
     * 
     * @return the value value.
     */
    public List<PrivateDnsZoneGroupInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of private dns zone group resources in a private endpoint.
     * 
     * @param value the value value to set.
     * @return the PrivateDnsZoneGroupListResult object itself.
     */
    public PrivateDnsZoneGroupListResult withValue(List<PrivateDnsZoneGroupInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateDnsZoneGroupListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateDnsZoneGroupListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PrivateDnsZoneGroupListResult.
     */
    public static PrivateDnsZoneGroupListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateDnsZoneGroupListResult deserializedPrivateDnsZoneGroupListResult
                = new PrivateDnsZoneGroupListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<PrivateDnsZoneGroupInner> value
                        = reader.readArray(reader1 -> PrivateDnsZoneGroupInner.fromJson(reader1));
                    deserializedPrivateDnsZoneGroupListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedPrivateDnsZoneGroupListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateDnsZoneGroupListResult;
        });
    }
}
