// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes a column to sort.
 */
@Fluent
public final class OrderBy implements JsonSerializable<OrderBy> {
    /*
     * Describes the actual column name to sort by
     */
    private String field;

    /*
     * Describes if results should be in ascending/descending order
     */
    private FirewallPolicyIdpsQuerySortOrder order;

    /**
     * Creates an instance of OrderBy class.
     */
    public OrderBy() {
    }

    /**
     * Get the field property: Describes the actual column name to sort by.
     * 
     * @return the field value.
     */
    public String field() {
        return this.field;
    }

    /**
     * Set the field property: Describes the actual column name to sort by.
     * 
     * @param field the field value to set.
     * @return the OrderBy object itself.
     */
    public OrderBy withField(String field) {
        this.field = field;
        return this;
    }

    /**
     * Get the order property: Describes if results should be in ascending/descending order.
     * 
     * @return the order value.
     */
    public FirewallPolicyIdpsQuerySortOrder order() {
        return this.order;
    }

    /**
     * Set the order property: Describes if results should be in ascending/descending order.
     * 
     * @param order the order value to set.
     * @return the OrderBy object itself.
     */
    public OrderBy withOrder(FirewallPolicyIdpsQuerySortOrder order) {
        this.order = order;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("field", this.field);
        jsonWriter.writeStringField("order", this.order == null ? null : this.order.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OrderBy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OrderBy if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the OrderBy.
     */
    public static OrderBy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OrderBy deserializedOrderBy = new OrderBy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("field".equals(fieldName)) {
                    deserializedOrderBy.field = reader.getString();
                } else if ("order".equals(fieldName)) {
                    deserializedOrderBy.order = FirewallPolicyIdpsQuerySortOrder.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOrderBy;
        });
    }
}
