// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Office365 breakout categories.
 */
@Fluent
public final class O365BreakOutCategoryPolicies implements JsonSerializable<O365BreakOutCategoryPolicies> {
    /*
     * Flag to control allow category.
     */
    private Boolean allow;

    /*
     * Flag to control optimize category.
     */
    private Boolean optimize;

    /*
     * Flag to control default category.
     */
    private Boolean defaultProperty;

    /**
     * Creates an instance of O365BreakOutCategoryPolicies class.
     */
    public O365BreakOutCategoryPolicies() {
    }

    /**
     * Get the allow property: Flag to control allow category.
     * 
     * @return the allow value.
     */
    public Boolean allow() {
        return this.allow;
    }

    /**
     * Set the allow property: Flag to control allow category.
     * 
     * @param allow the allow value to set.
     * @return the O365BreakOutCategoryPolicies object itself.
     */
    public O365BreakOutCategoryPolicies withAllow(Boolean allow) {
        this.allow = allow;
        return this;
    }

    /**
     * Get the optimize property: Flag to control optimize category.
     * 
     * @return the optimize value.
     */
    public Boolean optimize() {
        return this.optimize;
    }

    /**
     * Set the optimize property: Flag to control optimize category.
     * 
     * @param optimize the optimize value to set.
     * @return the O365BreakOutCategoryPolicies object itself.
     */
    public O365BreakOutCategoryPolicies withOptimize(Boolean optimize) {
        this.optimize = optimize;
        return this;
    }

    /**
     * Get the defaultProperty property: Flag to control default category.
     * 
     * @return the defaultProperty value.
     */
    public Boolean defaultProperty() {
        return this.defaultProperty;
    }

    /**
     * Set the defaultProperty property: Flag to control default category.
     * 
     * @param defaultProperty the defaultProperty value to set.
     * @return the O365BreakOutCategoryPolicies object itself.
     */
    public O365BreakOutCategoryPolicies withDefaultProperty(Boolean defaultProperty) {
        this.defaultProperty = defaultProperty;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allow", this.allow);
        jsonWriter.writeBooleanField("optimize", this.optimize);
        jsonWriter.writeBooleanField("default", this.defaultProperty);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of O365BreakOutCategoryPolicies from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of O365BreakOutCategoryPolicies if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the O365BreakOutCategoryPolicies.
     */
    public static O365BreakOutCategoryPolicies fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            O365BreakOutCategoryPolicies deserializedO365BreakOutCategoryPolicies = new O365BreakOutCategoryPolicies();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allow".equals(fieldName)) {
                    deserializedO365BreakOutCategoryPolicies.allow = reader.getNullable(JsonReader::getBoolean);
                } else if ("optimize".equals(fieldName)) {
                    deserializedO365BreakOutCategoryPolicies.optimize = reader.getNullable(JsonReader::getBoolean);
                } else if ("default".equals(fieldName)) {
                    deserializedO365BreakOutCategoryPolicies.defaultProperty
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedO365BreakOutCategoryPolicies;
        });
    }
}
