// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * NIC type. This should be either PublicNic or PrivateNic.
 */
public final class NicTypeInRequest extends ExpandableStringEnum<NicTypeInRequest> {
    /**
     * Static value PublicNic for NicTypeInRequest.
     */
    public static final NicTypeInRequest PUBLIC_NIC = fromString("PublicNic");

    /**
     * Static value PrivateNic for NicTypeInRequest.
     */
    public static final NicTypeInRequest PRIVATE_NIC = fromString("PrivateNic");

    /**
     * Creates a new instance of NicTypeInRequest value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public NicTypeInRequest() {
    }

    /**
     * Creates or finds a NicTypeInRequest from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding NicTypeInRequest.
     */
    public static NicTypeInRequest fromString(String name) {
        return fromString(name, NicTypeInRequest.class);
    }

    /**
     * Gets known NicTypeInRequest values.
     * 
     * @return known NicTypeInRequest values.
     */
    public static Collection<NicTypeInRequest> values() {
        return values(NicTypeInRequest.class);
    }
}
