// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VpnServerConfigurationInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list all VpnServerConfigurations. It contains a list of VpnServerConfigurations and a URL
 * nextLink to get the next set of results.
 */
@Fluent
public final class ListVpnServerConfigurationsResult implements JsonSerializable<ListVpnServerConfigurationsResult> {
    /*
     * List of VpnServerConfigurations.
     */
    private List<VpnServerConfigurationInner> value;

    /*
     * URL to get the next set of operation list results if there are any.
     */
    private String nextLink;

    /**
     * Creates an instance of ListVpnServerConfigurationsResult class.
     */
    public ListVpnServerConfigurationsResult() {
    }

    /**
     * Get the value property: List of VpnServerConfigurations.
     * 
     * @return the value value.
     */
    public List<VpnServerConfigurationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of VpnServerConfigurations.
     * 
     * @param value the value value to set.
     * @return the ListVpnServerConfigurationsResult object itself.
     */
    public ListVpnServerConfigurationsResult withValue(List<VpnServerConfigurationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ListVpnServerConfigurationsResult object itself.
     */
    public ListVpnServerConfigurationsResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListVpnServerConfigurationsResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListVpnServerConfigurationsResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ListVpnServerConfigurationsResult.
     */
    public static ListVpnServerConfigurationsResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ListVpnServerConfigurationsResult deserializedListVpnServerConfigurationsResult
                = new ListVpnServerConfigurationsResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VpnServerConfigurationInner> value
                        = reader.readArray(reader1 -> VpnServerConfigurationInner.fromJson(reader1));
                    deserializedListVpnServerConfigurationsResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedListVpnServerConfigurationsResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedListVpnServerConfigurationsResult;
        });
    }
}
