// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Internet Ingress Public Ip Properties
 * 
 * Resource Uri of Public Ip for Standard Load Balancer Frontend End.
 */
@Fluent
public final class InternetIngressPublicIpsProperties implements JsonSerializable<InternetIngressPublicIpsProperties> {
    /*
     * Resource Uri of Public Ip
     */
    private String id;

    /**
     * Creates an instance of InternetIngressPublicIpsProperties class.
     */
    public InternetIngressPublicIpsProperties() {
    }

    /**
     * Get the id property: Resource Uri of Public Ip.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource Uri of Public Ip.
     * 
     * @param id the id value to set.
     * @return the InternetIngressPublicIpsProperties object itself.
     */
    public InternetIngressPublicIpsProperties withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InternetIngressPublicIpsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of InternetIngressPublicIpsProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the InternetIngressPublicIpsProperties.
     */
    public static InternetIngressPublicIpsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InternetIngressPublicIpsProperties deserializedInternetIngressPublicIpsProperties
                = new InternetIngressPublicIpsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedInternetIngressPublicIpsProperties.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedInternetIngressPublicIpsProperties;
        });
    }
}
