// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The HTTP header.
 */
@Fluent
public final class HttpHeader implements JsonSerializable<HttpHeader> {
    /*
     * The name in HTTP header.
     */
    private String name;

    /*
     * The value in HTTP header.
     */
    private String value;

    /**
     * Creates an instance of HttpHeader class.
     */
    public HttpHeader() {
    }

    /**
     * Get the name property: The name in HTTP header.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name in HTTP header.
     * 
     * @param name the name value to set.
     * @return the HttpHeader object itself.
     */
    public HttpHeader withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: The value in HTTP header.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value in HTTP header.
     * 
     * @param value the value value to set.
     * @return the HttpHeader object itself.
     */
    public HttpHeader withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HttpHeader from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HttpHeader if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the HttpHeader.
     */
    public static HttpHeader fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HttpHeader deserializedHttpHeader = new HttpHeader();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedHttpHeader.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedHttpHeader.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHttpHeader;
        });
    }
}
