// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The customer name to be printed on a letter of authorization.
 */
@Fluent
public final class GenerateExpressRoutePortsLoaRequest
    implements JsonSerializable<GenerateExpressRoutePortsLoaRequest> {
    /*
     * The customer name.
     */
    private String customerName;

    /**
     * Creates an instance of GenerateExpressRoutePortsLoaRequest class.
     */
    public GenerateExpressRoutePortsLoaRequest() {
    }

    /**
     * Get the customerName property: The customer name.
     * 
     * @return the customerName value.
     */
    public String customerName() {
        return this.customerName;
    }

    /**
     * Set the customerName property: The customer name.
     * 
     * @param customerName the customerName value to set.
     * @return the GenerateExpressRoutePortsLoaRequest object itself.
     */
    public GenerateExpressRoutePortsLoaRequest withCustomerName(String customerName) {
        this.customerName = customerName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (customerName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property customerName in model GenerateExpressRoutePortsLoaRequest"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GenerateExpressRoutePortsLoaRequest.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("customerName", this.customerName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GenerateExpressRoutePortsLoaRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GenerateExpressRoutePortsLoaRequest if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GenerateExpressRoutePortsLoaRequest.
     */
    public static GenerateExpressRoutePortsLoaRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GenerateExpressRoutePortsLoaRequest deserializedGenerateExpressRoutePortsLoaRequest
                = new GenerateExpressRoutePortsLoaRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("customerName".equals(fieldName)) {
                    deserializedGenerateExpressRoutePortsLoaRequest.customerName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGenerateExpressRoutePortsLoaRequest;
        });
    }
}
