// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * SKU of Firewall policy.
 */
@Fluent
public final class FirewallPolicySku implements JsonSerializable<FirewallPolicySku> {
    /*
     * Tier of Firewall Policy.
     */
    private FirewallPolicySkuTier tier;

    /**
     * Creates an instance of FirewallPolicySku class.
     */
    public FirewallPolicySku() {
    }

    /**
     * Get the tier property: Tier of Firewall Policy.
     * 
     * @return the tier value.
     */
    public FirewallPolicySkuTier tier() {
        return this.tier;
    }

    /**
     * Set the tier property: Tier of Firewall Policy.
     * 
     * @param tier the tier value to set.
     * @return the FirewallPolicySku object itself.
     */
    public FirewallPolicySku withTier(FirewallPolicySkuTier tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FirewallPolicySku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FirewallPolicySku if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FirewallPolicySku.
     */
    public static FirewallPolicySku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FirewallPolicySku deserializedFirewallPolicySku = new FirewallPolicySku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tier".equals(fieldName)) {
                    deserializedFirewallPolicySku.tier = FirewallPolicySkuTier.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFirewallPolicySku;
        });
    }
}
