// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration for intrusion detection mode and rules.
 */
@Fluent
public final class FirewallPolicyIntrusionDetection implements JsonSerializable<FirewallPolicyIntrusionDetection> {
    /*
     * Intrusion detection general state. When attached to a parent policy, the firewall's effective IDPS mode is the
     * stricter mode of the two.
     */
    private FirewallPolicyIntrusionDetectionStateType mode;

    /*
     * IDPS profile name. When attached to a parent policy, the firewall's effective profile is the profile name of the
     * parent policy.
     */
    private FirewallPolicyIntrusionDetectionProfileType profile;

    /*
     * Intrusion detection configuration properties.
     */
    private FirewallPolicyIntrusionDetectionConfiguration configuration;

    /**
     * Creates an instance of FirewallPolicyIntrusionDetection class.
     */
    public FirewallPolicyIntrusionDetection() {
    }

    /**
     * Get the mode property: Intrusion detection general state. When attached to a parent policy, the firewall's
     * effective IDPS mode is the stricter mode of the two.
     * 
     * @return the mode value.
     */
    public FirewallPolicyIntrusionDetectionStateType mode() {
        return this.mode;
    }

    /**
     * Set the mode property: Intrusion detection general state. When attached to a parent policy, the firewall's
     * effective IDPS mode is the stricter mode of the two.
     * 
     * @param mode the mode value to set.
     * @return the FirewallPolicyIntrusionDetection object itself.
     */
    public FirewallPolicyIntrusionDetection withMode(FirewallPolicyIntrusionDetectionStateType mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the profile property: IDPS profile name. When attached to a parent policy, the firewall's effective profile
     * is the profile name of the parent policy.
     * 
     * @return the profile value.
     */
    public FirewallPolicyIntrusionDetectionProfileType profile() {
        return this.profile;
    }

    /**
     * Set the profile property: IDPS profile name. When attached to a parent policy, the firewall's effective profile
     * is the profile name of the parent policy.
     * 
     * @param profile the profile value to set.
     * @return the FirewallPolicyIntrusionDetection object itself.
     */
    public FirewallPolicyIntrusionDetection withProfile(FirewallPolicyIntrusionDetectionProfileType profile) {
        this.profile = profile;
        return this;
    }

    /**
     * Get the configuration property: Intrusion detection configuration properties.
     * 
     * @return the configuration value.
     */
    public FirewallPolicyIntrusionDetectionConfiguration configuration() {
        return this.configuration;
    }

    /**
     * Set the configuration property: Intrusion detection configuration properties.
     * 
     * @param configuration the configuration value to set.
     * @return the FirewallPolicyIntrusionDetection object itself.
     */
    public FirewallPolicyIntrusionDetection
        withConfiguration(FirewallPolicyIntrusionDetectionConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (configuration() != null) {
            configuration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeStringField("profile", this.profile == null ? null : this.profile.toString());
        jsonWriter.writeJsonField("configuration", this.configuration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FirewallPolicyIntrusionDetection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FirewallPolicyIntrusionDetection if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FirewallPolicyIntrusionDetection.
     */
    public static FirewallPolicyIntrusionDetection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FirewallPolicyIntrusionDetection deserializedFirewallPolicyIntrusionDetection
                = new FirewallPolicyIntrusionDetection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mode".equals(fieldName)) {
                    deserializedFirewallPolicyIntrusionDetection.mode
                        = FirewallPolicyIntrusionDetectionStateType.fromString(reader.getString());
                } else if ("profile".equals(fieldName)) {
                    deserializedFirewallPolicyIntrusionDetection.profile
                        = FirewallPolicyIntrusionDetectionProfileType.fromString(reader.getString());
                } else if ("configuration".equals(fieldName)) {
                    deserializedFirewallPolicyIntrusionDetection.configuration
                        = FirewallPolicyIntrusionDetectionConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFirewallPolicyIntrusionDetection;
        });
    }
}
