// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The routes table associated with the ExpressRouteCircuit.
 */
@Fluent
public final class ExpressRouteCrossConnectionRoutesTableSummary
    implements JsonSerializable<ExpressRouteCrossConnectionRoutesTableSummary> {
    /*
     * IP address of Neighbor router.
     */
    private String neighbor;

    /*
     * Autonomous system number.
     */
    private Integer asn;

    /*
     * The length of time that the BGP session has been in the Established state, or the current status if not in the
     * Established state.
     */
    private String upDown;

    /*
     * Current state of the BGP session, and the number of prefixes that have been received from a neighbor or peer
     * group.
     */
    private String stateOrPrefixesReceived;

    /**
     * Creates an instance of ExpressRouteCrossConnectionRoutesTableSummary class.
     */
    public ExpressRouteCrossConnectionRoutesTableSummary() {
    }

    /**
     * Get the neighbor property: IP address of Neighbor router.
     * 
     * @return the neighbor value.
     */
    public String neighbor() {
        return this.neighbor;
    }

    /**
     * Set the neighbor property: IP address of Neighbor router.
     * 
     * @param neighbor the neighbor value to set.
     * @return the ExpressRouteCrossConnectionRoutesTableSummary object itself.
     */
    public ExpressRouteCrossConnectionRoutesTableSummary withNeighbor(String neighbor) {
        this.neighbor = neighbor;
        return this;
    }

    /**
     * Get the asn property: Autonomous system number.
     * 
     * @return the asn value.
     */
    public Integer asn() {
        return this.asn;
    }

    /**
     * Set the asn property: Autonomous system number.
     * 
     * @param asn the asn value to set.
     * @return the ExpressRouteCrossConnectionRoutesTableSummary object itself.
     */
    public ExpressRouteCrossConnectionRoutesTableSummary withAsn(Integer asn) {
        this.asn = asn;
        return this;
    }

    /**
     * Get the upDown property: The length of time that the BGP session has been in the Established state, or the
     * current status if not in the Established state.
     * 
     * @return the upDown value.
     */
    public String upDown() {
        return this.upDown;
    }

    /**
     * Set the upDown property: The length of time that the BGP session has been in the Established state, or the
     * current status if not in the Established state.
     * 
     * @param upDown the upDown value to set.
     * @return the ExpressRouteCrossConnectionRoutesTableSummary object itself.
     */
    public ExpressRouteCrossConnectionRoutesTableSummary withUpDown(String upDown) {
        this.upDown = upDown;
        return this;
    }

    /**
     * Get the stateOrPrefixesReceived property: Current state of the BGP session, and the number of prefixes that have
     * been received from a neighbor or peer group.
     * 
     * @return the stateOrPrefixesReceived value.
     */
    public String stateOrPrefixesReceived() {
        return this.stateOrPrefixesReceived;
    }

    /**
     * Set the stateOrPrefixesReceived property: Current state of the BGP session, and the number of prefixes that have
     * been received from a neighbor or peer group.
     * 
     * @param stateOrPrefixesReceived the stateOrPrefixesReceived value to set.
     * @return the ExpressRouteCrossConnectionRoutesTableSummary object itself.
     */
    public ExpressRouteCrossConnectionRoutesTableSummary withStateOrPrefixesReceived(String stateOrPrefixesReceived) {
        this.stateOrPrefixesReceived = stateOrPrefixesReceived;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("neighbor", this.neighbor);
        jsonWriter.writeNumberField("asn", this.asn);
        jsonWriter.writeStringField("upDown", this.upDown);
        jsonWriter.writeStringField("stateOrPrefixesReceived", this.stateOrPrefixesReceived);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteCrossConnectionRoutesTableSummary from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteCrossConnectionRoutesTableSummary if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteCrossConnectionRoutesTableSummary.
     */
    public static ExpressRouteCrossConnectionRoutesTableSummary fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteCrossConnectionRoutesTableSummary deserializedExpressRouteCrossConnectionRoutesTableSummary
                = new ExpressRouteCrossConnectionRoutesTableSummary();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("neighbor".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionRoutesTableSummary.neighbor = reader.getString();
                } else if ("asn".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionRoutesTableSummary.asn
                        = reader.getNullable(JsonReader::getInt);
                } else if ("upDown".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionRoutesTableSummary.upDown = reader.getString();
                } else if ("stateOrPrefixesReceived".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionRoutesTableSummary.stateOrPrefixesReceived
                        = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteCrossConnectionRoutesTableSummary;
        });
    }
}
