// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionPeeringInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for ListPeering API service call retrieves all peerings that belong to an ExpressRouteCrossConnection.
 */
@Fluent
public final class ExpressRouteCrossConnectionPeeringList
    implements JsonSerializable<ExpressRouteCrossConnectionPeeringList> {
    /*
     * The peerings in an express route cross connection.
     */
    private List<ExpressRouteCrossConnectionPeeringInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ExpressRouteCrossConnectionPeeringList class.
     */
    public ExpressRouteCrossConnectionPeeringList() {
    }

    /**
     * Get the value property: The peerings in an express route cross connection.
     * 
     * @return the value value.
     */
    public List<ExpressRouteCrossConnectionPeeringInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The peerings in an express route cross connection.
     * 
     * @param value the value value to set.
     * @return the ExpressRouteCrossConnectionPeeringList object itself.
     */
    public ExpressRouteCrossConnectionPeeringList withValue(List<ExpressRouteCrossConnectionPeeringInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteCrossConnectionPeeringList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteCrossConnectionPeeringList if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteCrossConnectionPeeringList.
     */
    public static ExpressRouteCrossConnectionPeeringList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteCrossConnectionPeeringList deserializedExpressRouteCrossConnectionPeeringList
                = new ExpressRouteCrossConnectionPeeringList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ExpressRouteCrossConnectionPeeringInner> value
                        = reader.readArray(reader1 -> ExpressRouteCrossConnectionPeeringInner.fromJson(reader1));
                    deserializedExpressRouteCrossConnectionPeeringList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringList.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteCrossConnectionPeeringList;
        });
    }
}
