// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains SKU in an ExpressRouteCircuit.
 */
@Fluent
public final class ExpressRouteCircuitSku implements JsonSerializable<ExpressRouteCircuitSku> {
    /*
     * The name of the SKU.
     */
    private String name;

    /*
     * The tier of the SKU.
     */
    private ExpressRouteCircuitSkuTier tier;

    /*
     * The family of the SKU.
     */
    private ExpressRouteCircuitSkuFamily family;

    /**
     * Creates an instance of ExpressRouteCircuitSku class.
     */
    public ExpressRouteCircuitSku() {
    }

    /**
     * Get the name property: The name of the SKU.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the SKU.
     * 
     * @param name the name value to set.
     * @return the ExpressRouteCircuitSku object itself.
     */
    public ExpressRouteCircuitSku withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the tier property: The tier of the SKU.
     * 
     * @return the tier value.
     */
    public ExpressRouteCircuitSkuTier tier() {
        return this.tier;
    }

    /**
     * Set the tier property: The tier of the SKU.
     * 
     * @param tier the tier value to set.
     * @return the ExpressRouteCircuitSku object itself.
     */
    public ExpressRouteCircuitSku withTier(ExpressRouteCircuitSkuTier tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Get the family property: The family of the SKU.
     * 
     * @return the family value.
     */
    public ExpressRouteCircuitSkuFamily family() {
        return this.family;
    }

    /**
     * Set the family property: The family of the SKU.
     * 
     * @param family the family value to set.
     * @return the ExpressRouteCircuitSku object itself.
     */
    public ExpressRouteCircuitSku withFamily(ExpressRouteCircuitSkuFamily family) {
        this.family = family;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        jsonWriter.writeStringField("family", this.family == null ? null : this.family.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteCircuitSku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteCircuitSku if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteCircuitSku.
     */
    public static ExpressRouteCircuitSku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteCircuitSku deserializedExpressRouteCircuitSku = new ExpressRouteCircuitSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedExpressRouteCircuitSku.name = reader.getString();
                } else if ("tier".equals(fieldName)) {
                    deserializedExpressRouteCircuitSku.tier = ExpressRouteCircuitSkuTier.fromString(reader.getString());
                } else if ("family".equals(fieldName)) {
                    deserializedExpressRouteCircuitSku.family
                        = ExpressRouteCircuitSkuFamily.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteCircuitSku;
        });
    }
}
