// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * ExpressRoute circuit peering identifier.
 */
@Fluent
public final class ExpressRouteCircuitPeeringId implements JsonSerializable<ExpressRouteCircuitPeeringId> {
    /*
     * The ID of the ExpressRoute circuit peering.
     */
    private String id;

    /**
     * Creates an instance of ExpressRouteCircuitPeeringId class.
     */
    public ExpressRouteCircuitPeeringId() {
    }

    /**
     * Get the id property: The ID of the ExpressRoute circuit peering.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The ID of the ExpressRoute circuit peering.
     * 
     * @param id the id value to set.
     * @return the ExpressRouteCircuitPeeringId object itself.
     */
    public ExpressRouteCircuitPeeringId withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteCircuitPeeringId from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteCircuitPeeringId if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteCircuitPeeringId.
     */
    public static ExpressRouteCircuitPeeringId fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteCircuitPeeringId deserializedExpressRouteCircuitPeeringId = new ExpressRouteCircuitPeeringId();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedExpressRouteCircuitPeeringId.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteCircuitPeeringId;
        });
    }
}
