// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Connection state snapshot.
 */
@Fluent
public final class ConnectionStateSnapshot implements JsonSerializable<ConnectionStateSnapshot> {
    /*
     * The connection state.
     */
    private ConnectionState connectionState;

    /*
     * The start time of the connection snapshot.
     */
    private OffsetDateTime startTime;

    /*
     * The end time of the connection snapshot.
     */
    private OffsetDateTime endTime;

    /*
     * Connectivity analysis evaluation state.
     */
    private EvaluationState evaluationState;

    /*
     * Average latency in ms.
     */
    private Long avgLatencyInMs;

    /*
     * Minimum latency in ms.
     */
    private Long minLatencyInMs;

    /*
     * Maximum latency in ms.
     */
    private Long maxLatencyInMs;

    /*
     * The number of sent probes.
     */
    private Long probesSent;

    /*
     * The number of failed probes.
     */
    private Long probesFailed;

    /*
     * List of hops between the source and the destination.
     */
    private List<ConnectivityHop> hops;

    /**
     * Creates an instance of ConnectionStateSnapshot class.
     */
    public ConnectionStateSnapshot() {
    }

    /**
     * Get the connectionState property: The connection state.
     * 
     * @return the connectionState value.
     */
    public ConnectionState connectionState() {
        return this.connectionState;
    }

    /**
     * Set the connectionState property: The connection state.
     * 
     * @param connectionState the connectionState value to set.
     * @return the ConnectionStateSnapshot object itself.
     */
    public ConnectionStateSnapshot withConnectionState(ConnectionState connectionState) {
        this.connectionState = connectionState;
        return this;
    }

    /**
     * Get the startTime property: The start time of the connection snapshot.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: The start time of the connection snapshot.
     * 
     * @param startTime the startTime value to set.
     * @return the ConnectionStateSnapshot object itself.
     */
    public ConnectionStateSnapshot withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: The end time of the connection snapshot.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: The end time of the connection snapshot.
     * 
     * @param endTime the endTime value to set.
     * @return the ConnectionStateSnapshot object itself.
     */
    public ConnectionStateSnapshot withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the evaluationState property: Connectivity analysis evaluation state.
     * 
     * @return the evaluationState value.
     */
    public EvaluationState evaluationState() {
        return this.evaluationState;
    }

    /**
     * Set the evaluationState property: Connectivity analysis evaluation state.
     * 
     * @param evaluationState the evaluationState value to set.
     * @return the ConnectionStateSnapshot object itself.
     */
    public ConnectionStateSnapshot withEvaluationState(EvaluationState evaluationState) {
        this.evaluationState = evaluationState;
        return this;
    }

    /**
     * Get the avgLatencyInMs property: Average latency in ms.
     * 
     * @return the avgLatencyInMs value.
     */
    public Long avgLatencyInMs() {
        return this.avgLatencyInMs;
    }

    /**
     * Set the avgLatencyInMs property: Average latency in ms.
     * 
     * @param avgLatencyInMs the avgLatencyInMs value to set.
     * @return the ConnectionStateSnapshot object itself.
     */
    public ConnectionStateSnapshot withAvgLatencyInMs(Long avgLatencyInMs) {
        this.avgLatencyInMs = avgLatencyInMs;
        return this;
    }

    /**
     * Get the minLatencyInMs property: Minimum latency in ms.
     * 
     * @return the minLatencyInMs value.
     */
    public Long minLatencyInMs() {
        return this.minLatencyInMs;
    }

    /**
     * Set the minLatencyInMs property: Minimum latency in ms.
     * 
     * @param minLatencyInMs the minLatencyInMs value to set.
     * @return the ConnectionStateSnapshot object itself.
     */
    public ConnectionStateSnapshot withMinLatencyInMs(Long minLatencyInMs) {
        this.minLatencyInMs = minLatencyInMs;
        return this;
    }

    /**
     * Get the maxLatencyInMs property: Maximum latency in ms.
     * 
     * @return the maxLatencyInMs value.
     */
    public Long maxLatencyInMs() {
        return this.maxLatencyInMs;
    }

    /**
     * Set the maxLatencyInMs property: Maximum latency in ms.
     * 
     * @param maxLatencyInMs the maxLatencyInMs value to set.
     * @return the ConnectionStateSnapshot object itself.
     */
    public ConnectionStateSnapshot withMaxLatencyInMs(Long maxLatencyInMs) {
        this.maxLatencyInMs = maxLatencyInMs;
        return this;
    }

    /**
     * Get the probesSent property: The number of sent probes.
     * 
     * @return the probesSent value.
     */
    public Long probesSent() {
        return this.probesSent;
    }

    /**
     * Set the probesSent property: The number of sent probes.
     * 
     * @param probesSent the probesSent value to set.
     * @return the ConnectionStateSnapshot object itself.
     */
    public ConnectionStateSnapshot withProbesSent(Long probesSent) {
        this.probesSent = probesSent;
        return this;
    }

    /**
     * Get the probesFailed property: The number of failed probes.
     * 
     * @return the probesFailed value.
     */
    public Long probesFailed() {
        return this.probesFailed;
    }

    /**
     * Set the probesFailed property: The number of failed probes.
     * 
     * @param probesFailed the probesFailed value to set.
     * @return the ConnectionStateSnapshot object itself.
     */
    public ConnectionStateSnapshot withProbesFailed(Long probesFailed) {
        this.probesFailed = probesFailed;
        return this;
    }

    /**
     * Get the hops property: List of hops between the source and the destination.
     * 
     * @return the hops value.
     */
    public List<ConnectivityHop> hops() {
        return this.hops;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (hops() != null) {
            hops().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectionState",
            this.connectionState == null ? null : this.connectionState.toString());
        jsonWriter.writeStringField("startTime",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime",
            this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("evaluationState",
            this.evaluationState == null ? null : this.evaluationState.toString());
        jsonWriter.writeNumberField("avgLatencyInMs", this.avgLatencyInMs);
        jsonWriter.writeNumberField("minLatencyInMs", this.minLatencyInMs);
        jsonWriter.writeNumberField("maxLatencyInMs", this.maxLatencyInMs);
        jsonWriter.writeNumberField("probesSent", this.probesSent);
        jsonWriter.writeNumberField("probesFailed", this.probesFailed);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionStateSnapshot from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionStateSnapshot if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectionStateSnapshot.
     */
    public static ConnectionStateSnapshot fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionStateSnapshot deserializedConnectionStateSnapshot = new ConnectionStateSnapshot();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("connectionState".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.connectionState
                        = ConnectionState.fromString(reader.getString());
                } else if ("startTime".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endTime".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("evaluationState".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.evaluationState
                        = EvaluationState.fromString(reader.getString());
                } else if ("avgLatencyInMs".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.avgLatencyInMs = reader.getNullable(JsonReader::getLong);
                } else if ("minLatencyInMs".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.minLatencyInMs = reader.getNullable(JsonReader::getLong);
                } else if ("maxLatencyInMs".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.maxLatencyInMs = reader.getNullable(JsonReader::getLong);
                } else if ("probesSent".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.probesSent = reader.getNullable(JsonReader::getLong);
                } else if ("probesFailed".equals(fieldName)) {
                    deserializedConnectionStateSnapshot.probesFailed = reader.getNullable(JsonReader::getLong);
                } else if ("hops".equals(fieldName)) {
                    List<ConnectivityHop> hops = reader.readArray(reader1 -> ConnectivityHop.fromJson(reader1));
                    deserializedConnectionStateSnapshot.hops = hops;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionStateSnapshot;
        });
    }
}
