// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes a connection monitor test configuration.
 */
@Fluent
public final class ConnectionMonitorTestConfiguration implements JsonSerializable<ConnectionMonitorTestConfiguration> {
    /*
     * The name of the connection monitor test configuration.
     */
    private String name;

    /*
     * The frequency of test evaluation, in seconds.
     */
    private Integer testFrequencySec;

    /*
     * The protocol to use in test evaluation.
     */
    private ConnectionMonitorTestConfigurationProtocol protocol;

    /*
     * The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version
     * depending on other parameters.
     */
    private PreferredIpVersion preferredIpVersion;

    /*
     * The parameters used to perform test evaluation over HTTP.
     */
    private ConnectionMonitorHttpConfiguration httpConfiguration;

    /*
     * The parameters used to perform test evaluation over TCP.
     */
    private ConnectionMonitorTcpConfiguration tcpConfiguration;

    /*
     * The parameters used to perform test evaluation over ICMP.
     */
    private ConnectionMonitorIcmpConfiguration icmpConfiguration;

    /*
     * The threshold for declaring a test successful.
     */
    private ConnectionMonitorSuccessThreshold successThreshold;

    /**
     * Creates an instance of ConnectionMonitorTestConfiguration class.
     */
    public ConnectionMonitorTestConfiguration() {
    }

    /**
     * Get the name property: The name of the connection monitor test configuration.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the connection monitor test configuration.
     * 
     * @param name the name value to set.
     * @return the ConnectionMonitorTestConfiguration object itself.
     */
    public ConnectionMonitorTestConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the testFrequencySec property: The frequency of test evaluation, in seconds.
     * 
     * @return the testFrequencySec value.
     */
    public Integer testFrequencySec() {
        return this.testFrequencySec;
    }

    /**
     * Set the testFrequencySec property: The frequency of test evaluation, in seconds.
     * 
     * @param testFrequencySec the testFrequencySec value to set.
     * @return the ConnectionMonitorTestConfiguration object itself.
     */
    public ConnectionMonitorTestConfiguration withTestFrequencySec(Integer testFrequencySec) {
        this.testFrequencySec = testFrequencySec;
        return this;
    }

    /**
     * Get the protocol property: The protocol to use in test evaluation.
     * 
     * @return the protocol value.
     */
    public ConnectionMonitorTestConfigurationProtocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: The protocol to use in test evaluation.
     * 
     * @param protocol the protocol value to set.
     * @return the ConnectionMonitorTestConfiguration object itself.
     */
    public ConnectionMonitorTestConfiguration withProtocol(ConnectionMonitorTestConfigurationProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the preferredIpVersion property: The preferred IP version to use in test evaluation. The connection monitor
     * may choose to use a different version depending on other parameters.
     * 
     * @return the preferredIpVersion value.
     */
    public PreferredIpVersion preferredIpVersion() {
        return this.preferredIpVersion;
    }

    /**
     * Set the preferredIpVersion property: The preferred IP version to use in test evaluation. The connection monitor
     * may choose to use a different version depending on other parameters.
     * 
     * @param preferredIpVersion the preferredIpVersion value to set.
     * @return the ConnectionMonitorTestConfiguration object itself.
     */
    public ConnectionMonitorTestConfiguration withPreferredIpVersion(PreferredIpVersion preferredIpVersion) {
        this.preferredIpVersion = preferredIpVersion;
        return this;
    }

    /**
     * Get the httpConfiguration property: The parameters used to perform test evaluation over HTTP.
     * 
     * @return the httpConfiguration value.
     */
    public ConnectionMonitorHttpConfiguration httpConfiguration() {
        return this.httpConfiguration;
    }

    /**
     * Set the httpConfiguration property: The parameters used to perform test evaluation over HTTP.
     * 
     * @param httpConfiguration the httpConfiguration value to set.
     * @return the ConnectionMonitorTestConfiguration object itself.
     */
    public ConnectionMonitorTestConfiguration
        withHttpConfiguration(ConnectionMonitorHttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
        return this;
    }

    /**
     * Get the tcpConfiguration property: The parameters used to perform test evaluation over TCP.
     * 
     * @return the tcpConfiguration value.
     */
    public ConnectionMonitorTcpConfiguration tcpConfiguration() {
        return this.tcpConfiguration;
    }

    /**
     * Set the tcpConfiguration property: The parameters used to perform test evaluation over TCP.
     * 
     * @param tcpConfiguration the tcpConfiguration value to set.
     * @return the ConnectionMonitorTestConfiguration object itself.
     */
    public ConnectionMonitorTestConfiguration withTcpConfiguration(ConnectionMonitorTcpConfiguration tcpConfiguration) {
        this.tcpConfiguration = tcpConfiguration;
        return this;
    }

    /**
     * Get the icmpConfiguration property: The parameters used to perform test evaluation over ICMP.
     * 
     * @return the icmpConfiguration value.
     */
    public ConnectionMonitorIcmpConfiguration icmpConfiguration() {
        return this.icmpConfiguration;
    }

    /**
     * Set the icmpConfiguration property: The parameters used to perform test evaluation over ICMP.
     * 
     * @param icmpConfiguration the icmpConfiguration value to set.
     * @return the ConnectionMonitorTestConfiguration object itself.
     */
    public ConnectionMonitorTestConfiguration
        withIcmpConfiguration(ConnectionMonitorIcmpConfiguration icmpConfiguration) {
        this.icmpConfiguration = icmpConfiguration;
        return this;
    }

    /**
     * Get the successThreshold property: The threshold for declaring a test successful.
     * 
     * @return the successThreshold value.
     */
    public ConnectionMonitorSuccessThreshold successThreshold() {
        return this.successThreshold;
    }

    /**
     * Set the successThreshold property: The threshold for declaring a test successful.
     * 
     * @param successThreshold the successThreshold value to set.
     * @return the ConnectionMonitorTestConfiguration object itself.
     */
    public ConnectionMonitorTestConfiguration withSuccessThreshold(ConnectionMonitorSuccessThreshold successThreshold) {
        this.successThreshold = successThreshold;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property name in model ConnectionMonitorTestConfiguration"));
        }
        if (protocol() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property protocol in model ConnectionMonitorTestConfiguration"));
        }
        if (httpConfiguration() != null) {
            httpConfiguration().validate();
        }
        if (tcpConfiguration() != null) {
            tcpConfiguration().validate();
        }
        if (icmpConfiguration() != null) {
            icmpConfiguration().validate();
        }
        if (successThreshold() != null) {
            successThreshold().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ConnectionMonitorTestConfiguration.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeNumberField("testFrequencySec", this.testFrequencySec);
        jsonWriter.writeStringField("preferredIPVersion",
            this.preferredIpVersion == null ? null : this.preferredIpVersion.toString());
        jsonWriter.writeJsonField("httpConfiguration", this.httpConfiguration);
        jsonWriter.writeJsonField("tcpConfiguration", this.tcpConfiguration);
        jsonWriter.writeJsonField("icmpConfiguration", this.icmpConfiguration);
        jsonWriter.writeJsonField("successThreshold", this.successThreshold);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionMonitorTestConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionMonitorTestConfiguration if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectionMonitorTestConfiguration.
     */
    public static ConnectionMonitorTestConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionMonitorTestConfiguration deserializedConnectionMonitorTestConfiguration
                = new ConnectionMonitorTestConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.name = reader.getString();
                } else if ("protocol".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.protocol
                        = ConnectionMonitorTestConfigurationProtocol.fromString(reader.getString());
                } else if ("testFrequencySec".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.testFrequencySec
                        = reader.getNullable(JsonReader::getInt);
                } else if ("preferredIPVersion".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.preferredIpVersion
                        = PreferredIpVersion.fromString(reader.getString());
                } else if ("httpConfiguration".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.httpConfiguration
                        = ConnectionMonitorHttpConfiguration.fromJson(reader);
                } else if ("tcpConfiguration".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.tcpConfiguration
                        = ConnectionMonitorTcpConfiguration.fromJson(reader);
                } else if ("icmpConfiguration".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.icmpConfiguration
                        = ConnectionMonitorIcmpConfiguration.fromJson(reader);
                } else if ("successThreshold".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.successThreshold
                        = ConnectionMonitorSuccessThreshold.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionMonitorTestConfiguration;
        });
    }
}
