// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes the connection monitor endpoint scope.
 */
@Fluent
public final class ConnectionMonitorEndpointScope implements JsonSerializable<ConnectionMonitorEndpointScope> {
    /*
     * List of items which needs to be included to the endpoint scope.
     */
    private List<ConnectionMonitorEndpointScopeItem> include;

    /*
     * List of items which needs to be excluded from the endpoint scope.
     */
    private List<ConnectionMonitorEndpointScopeItem> exclude;

    /**
     * Creates an instance of ConnectionMonitorEndpointScope class.
     */
    public ConnectionMonitorEndpointScope() {
    }

    /**
     * Get the include property: List of items which needs to be included to the endpoint scope.
     * 
     * @return the include value.
     */
    public List<ConnectionMonitorEndpointScopeItem> include() {
        return this.include;
    }

    /**
     * Set the include property: List of items which needs to be included to the endpoint scope.
     * 
     * @param include the include value to set.
     * @return the ConnectionMonitorEndpointScope object itself.
     */
    public ConnectionMonitorEndpointScope withInclude(List<ConnectionMonitorEndpointScopeItem> include) {
        this.include = include;
        return this;
    }

    /**
     * Get the exclude property: List of items which needs to be excluded from the endpoint scope.
     * 
     * @return the exclude value.
     */
    public List<ConnectionMonitorEndpointScopeItem> exclude() {
        return this.exclude;
    }

    /**
     * Set the exclude property: List of items which needs to be excluded from the endpoint scope.
     * 
     * @param exclude the exclude value to set.
     * @return the ConnectionMonitorEndpointScope object itself.
     */
    public ConnectionMonitorEndpointScope withExclude(List<ConnectionMonitorEndpointScopeItem> exclude) {
        this.exclude = exclude;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (include() != null) {
            include().forEach(e -> e.validate());
        }
        if (exclude() != null) {
            exclude().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("include", this.include, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("exclude", this.exclude, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionMonitorEndpointScope from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionMonitorEndpointScope if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectionMonitorEndpointScope.
     */
    public static ConnectionMonitorEndpointScope fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionMonitorEndpointScope deserializedConnectionMonitorEndpointScope
                = new ConnectionMonitorEndpointScope();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("include".equals(fieldName)) {
                    List<ConnectionMonitorEndpointScopeItem> include
                        = reader.readArray(reader1 -> ConnectionMonitorEndpointScopeItem.fromJson(reader1));
                    deserializedConnectionMonitorEndpointScope.include = include;
                } else if ("exclude".equals(fieldName)) {
                    List<ConnectionMonitorEndpointScopeItem> exclude
                        = reader.readArray(reader1 -> ConnectionMonitorEndpointScopeItem.fromJson(reader1));
                    deserializedConnectionMonitorEndpointScope.exclude = exclude;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionMonitorEndpointScope;
        });
    }
}
