// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Availability of the metric.
 */
@Fluent
public final class Availability implements JsonSerializable<Availability> {
    /*
     * The time grain of the availability.
     */
    private String timeGrain;

    /*
     * The retention of the availability.
     */
    private String retention;

    /*
     * Duration of the availability blob.
     */
    private String blobDuration;

    /**
     * Creates an instance of Availability class.
     */
    public Availability() {
    }

    /**
     * Get the timeGrain property: The time grain of the availability.
     * 
     * @return the timeGrain value.
     */
    public String timeGrain() {
        return this.timeGrain;
    }

    /**
     * Set the timeGrain property: The time grain of the availability.
     * 
     * @param timeGrain the timeGrain value to set.
     * @return the Availability object itself.
     */
    public Availability withTimeGrain(String timeGrain) {
        this.timeGrain = timeGrain;
        return this;
    }

    /**
     * Get the retention property: The retention of the availability.
     * 
     * @return the retention value.
     */
    public String retention() {
        return this.retention;
    }

    /**
     * Set the retention property: The retention of the availability.
     * 
     * @param retention the retention value to set.
     * @return the Availability object itself.
     */
    public Availability withRetention(String retention) {
        this.retention = retention;
        return this;
    }

    /**
     * Get the blobDuration property: Duration of the availability blob.
     * 
     * @return the blobDuration value.
     */
    public String blobDuration() {
        return this.blobDuration;
    }

    /**
     * Set the blobDuration property: Duration of the availability blob.
     * 
     * @param blobDuration the blobDuration value to set.
     * @return the Availability object itself.
     */
    public Availability withBlobDuration(String blobDuration) {
        this.blobDuration = blobDuration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeGrain", this.timeGrain);
        jsonWriter.writeStringField("retention", this.retention);
        jsonWriter.writeStringField("blobDuration", this.blobDuration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Availability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Availability if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the Availability.
     */
    public static Availability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Availability deserializedAvailability = new Availability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("timeGrain".equals(fieldName)) {
                    deserializedAvailability.timeGrain = reader.getString();
                } else if ("retention".equals(fieldName)) {
                    deserializedAvailability.retention = reader.getString();
                } else if ("blobDuration".equals(fieldName)) {
                    deserializedAvailability.blobDuration = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAvailability;
        });
    }
}
