// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.Delegation;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.ResourceNavigationLink;
import com.azure.resourcemanager.network.models.ServiceAssociationLink;
import com.azure.resourcemanager.network.models.ServiceEndpointPropertiesFormat;
import com.azure.resourcemanager.network.models.SharingScope;
import com.azure.resourcemanager.network.models.VirtualNetworkPrivateEndpointNetworkPolicies;
import com.azure.resourcemanager.network.models.VirtualNetworkPrivateLinkServiceNetworkPolicies;
import java.io.IOException;
import java.util.List;

/**
 * Properties of the subnet.
 */
@Fluent
public final class SubnetPropertiesFormatInner implements JsonSerializable<SubnetPropertiesFormatInner> {
    /*
     * The address prefix for the subnet.
     */
    private String addressPrefix;

    /*
     * List of address prefixes for the subnet.
     */
    private List<String> addressPrefixes;

    /*
     * The reference to the NetworkSecurityGroup resource.
     */
    private NetworkSecurityGroupInner networkSecurityGroup;

    /*
     * The reference to the RouteTable resource.
     */
    private RouteTableInner routeTable;

    /*
     * Nat gateway associated with this subnet.
     */
    private SubResource natGateway;

    /*
     * An array of service endpoints.
     */
    private List<ServiceEndpointPropertiesFormat> serviceEndpoints;

    /*
     * An array of service endpoint policies.
     */
    private List<ServiceEndpointPolicyInner> serviceEndpointPolicies;

    /*
     * An array of references to private endpoints.
     */
    private List<PrivateEndpointInner> privateEndpoints;

    /*
     * An array of references to the network interface IP configurations using subnet.
     */
    private List<IpConfigurationInner> ipConfigurations;

    /*
     * Array of IP configuration profiles which reference this subnet.
     */
    private List<IpConfigurationProfileInner> ipConfigurationProfiles;

    /*
     * Array of IpAllocation which reference this subnet.
     */
    private List<SubResource> ipAllocations;

    /*
     * An array of references to the external resources using subnet.
     */
    private List<ResourceNavigationLink> resourceNavigationLinks;

    /*
     * An array of references to services injecting into this subnet.
     */
    private List<ServiceAssociationLink> serviceAssociationLinks;

    /*
     * An array of references to the delegations on the subnet.
     */
    private List<Delegation> delegations;

    /*
     * A read-only string identifying the intention of use for this subnet based on delegations and other user-defined
     * properties.
     */
    private String purpose;

    /*
     * The provisioning state of the subnet resource.
     */
    private ProvisioningState provisioningState;

    /*
     * Enable or Disable apply network policies on private end point in the subnet.
     */
    private VirtualNetworkPrivateEndpointNetworkPolicies privateEndpointNetworkPolicies;

    /*
     * Enable or Disable apply network policies on private link service in the subnet.
     */
    private VirtualNetworkPrivateLinkServiceNetworkPolicies privateLinkServiceNetworkPolicies;

    /*
     * Application gateway IP configurations of virtual network resource.
     */
    private List<ApplicationGatewayIpConfigurationInner> applicationGatewayIpConfigurations;

    /*
     * Set this property to Tenant to allow sharing subnet with other subscriptions in your AAD tenant. This property
     * can only be set if defaultOutboundAccess is set to false, both properties can only be set if subnet is empty.
     */
    private SharingScope sharingScope;

    /*
     * Set this property to false to disable default outbound connectivity for all VMs in the subnet. This property can
     * only be set at the time of subnet creation and cannot be updated for an existing subnet.
     */
    private Boolean defaultOutboundAccess;

    /**
     * Creates an instance of SubnetPropertiesFormatInner class.
     */
    public SubnetPropertiesFormatInner() {
    }

    /**
     * Get the addressPrefix property: The address prefix for the subnet.
     * 
     * @return the addressPrefix value.
     */
    public String addressPrefix() {
        return this.addressPrefix;
    }

    /**
     * Set the addressPrefix property: The address prefix for the subnet.
     * 
     * @param addressPrefix the addressPrefix value to set.
     * @return the SubnetPropertiesFormatInner object itself.
     */
    public SubnetPropertiesFormatInner withAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
        return this;
    }

    /**
     * Get the addressPrefixes property: List of address prefixes for the subnet.
     * 
     * @return the addressPrefixes value.
     */
    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    /**
     * Set the addressPrefixes property: List of address prefixes for the subnet.
     * 
     * @param addressPrefixes the addressPrefixes value to set.
     * @return the SubnetPropertiesFormatInner object itself.
     */
    public SubnetPropertiesFormatInner withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    /**
     * Get the networkSecurityGroup property: The reference to the NetworkSecurityGroup resource.
     * 
     * @return the networkSecurityGroup value.
     */
    public NetworkSecurityGroupInner networkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    /**
     * Set the networkSecurityGroup property: The reference to the NetworkSecurityGroup resource.
     * 
     * @param networkSecurityGroup the networkSecurityGroup value to set.
     * @return the SubnetPropertiesFormatInner object itself.
     */
    public SubnetPropertiesFormatInner withNetworkSecurityGroup(NetworkSecurityGroupInner networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
        return this;
    }

    /**
     * Get the routeTable property: The reference to the RouteTable resource.
     * 
     * @return the routeTable value.
     */
    public RouteTableInner routeTable() {
        return this.routeTable;
    }

    /**
     * Set the routeTable property: The reference to the RouteTable resource.
     * 
     * @param routeTable the routeTable value to set.
     * @return the SubnetPropertiesFormatInner object itself.
     */
    public SubnetPropertiesFormatInner withRouteTable(RouteTableInner routeTable) {
        this.routeTable = routeTable;
        return this;
    }

    /**
     * Get the natGateway property: Nat gateway associated with this subnet.
     * 
     * @return the natGateway value.
     */
    public SubResource natGateway() {
        return this.natGateway;
    }

    /**
     * Set the natGateway property: Nat gateway associated with this subnet.
     * 
     * @param natGateway the natGateway value to set.
     * @return the SubnetPropertiesFormatInner object itself.
     */
    public SubnetPropertiesFormatInner withNatGateway(SubResource natGateway) {
        this.natGateway = natGateway;
        return this;
    }

    /**
     * Get the serviceEndpoints property: An array of service endpoints.
     * 
     * @return the serviceEndpoints value.
     */
    public List<ServiceEndpointPropertiesFormat> serviceEndpoints() {
        return this.serviceEndpoints;
    }

    /**
     * Set the serviceEndpoints property: An array of service endpoints.
     * 
     * @param serviceEndpoints the serviceEndpoints value to set.
     * @return the SubnetPropertiesFormatInner object itself.
     */
    public SubnetPropertiesFormatInner withServiceEndpoints(List<ServiceEndpointPropertiesFormat> serviceEndpoints) {
        this.serviceEndpoints = serviceEndpoints;
        return this;
    }

    /**
     * Get the serviceEndpointPolicies property: An array of service endpoint policies.
     * 
     * @return the serviceEndpointPolicies value.
     */
    public List<ServiceEndpointPolicyInner> serviceEndpointPolicies() {
        return this.serviceEndpointPolicies;
    }

    /**
     * Set the serviceEndpointPolicies property: An array of service endpoint policies.
     * 
     * @param serviceEndpointPolicies the serviceEndpointPolicies value to set.
     * @return the SubnetPropertiesFormatInner object itself.
     */
    public SubnetPropertiesFormatInner
        withServiceEndpointPolicies(List<ServiceEndpointPolicyInner> serviceEndpointPolicies) {
        this.serviceEndpointPolicies = serviceEndpointPolicies;
        return this;
    }

    /**
     * Get the privateEndpoints property: An array of references to private endpoints.
     * 
     * @return the privateEndpoints value.
     */
    public List<PrivateEndpointInner> privateEndpoints() {
        return this.privateEndpoints;
    }

    /**
     * Get the ipConfigurations property: An array of references to the network interface IP configurations using
     * subnet.
     * 
     * @return the ipConfigurations value.
     */
    public List<IpConfigurationInner> ipConfigurations() {
        return this.ipConfigurations;
    }

    /**
     * Get the ipConfigurationProfiles property: Array of IP configuration profiles which reference this subnet.
     * 
     * @return the ipConfigurationProfiles value.
     */
    public List<IpConfigurationProfileInner> ipConfigurationProfiles() {
        return this.ipConfigurationProfiles;
    }

    /**
     * Get the ipAllocations property: Array of IpAllocation which reference this subnet.
     * 
     * @return the ipAllocations value.
     */
    public List<SubResource> ipAllocations() {
        return this.ipAllocations;
    }

    /**
     * Set the ipAllocations property: Array of IpAllocation which reference this subnet.
     * 
     * @param ipAllocations the ipAllocations value to set.
     * @return the SubnetPropertiesFormatInner object itself.
     */
    public SubnetPropertiesFormatInner withIpAllocations(List<SubResource> ipAllocations) {
        this.ipAllocations = ipAllocations;
        return this;
    }

    /**
     * Get the resourceNavigationLinks property: An array of references to the external resources using subnet.
     * 
     * @return the resourceNavigationLinks value.
     */
    public List<ResourceNavigationLink> resourceNavigationLinks() {
        return this.resourceNavigationLinks;
    }

    /**
     * Get the serviceAssociationLinks property: An array of references to services injecting into this subnet.
     * 
     * @return the serviceAssociationLinks value.
     */
    public List<ServiceAssociationLink> serviceAssociationLinks() {
        return this.serviceAssociationLinks;
    }

    /**
     * Get the delegations property: An array of references to the delegations on the subnet.
     * 
     * @return the delegations value.
     */
    public List<Delegation> delegations() {
        return this.delegations;
    }

    /**
     * Set the delegations property: An array of references to the delegations on the subnet.
     * 
     * @param delegations the delegations value to set.
     * @return the SubnetPropertiesFormatInner object itself.
     */
    public SubnetPropertiesFormatInner withDelegations(List<Delegation> delegations) {
        this.delegations = delegations;
        return this;
    }

    /**
     * Get the purpose property: A read-only string identifying the intention of use for this subnet based on
     * delegations and other user-defined properties.
     * 
     * @return the purpose value.
     */
    public String purpose() {
        return this.purpose;
    }

    /**
     * Get the provisioningState property: The provisioning state of the subnet resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the privateEndpointNetworkPolicies property: Enable or Disable apply network policies on private end point in
     * the subnet.
     * 
     * @return the privateEndpointNetworkPolicies value.
     */
    public VirtualNetworkPrivateEndpointNetworkPolicies privateEndpointNetworkPolicies() {
        return this.privateEndpointNetworkPolicies;
    }

    /**
     * Set the privateEndpointNetworkPolicies property: Enable or Disable apply network policies on private end point in
     * the subnet.
     * 
     * @param privateEndpointNetworkPolicies the privateEndpointNetworkPolicies value to set.
     * @return the SubnetPropertiesFormatInner object itself.
     */
    public SubnetPropertiesFormatInner withPrivateEndpointNetworkPolicies(
        VirtualNetworkPrivateEndpointNetworkPolicies privateEndpointNetworkPolicies) {
        this.privateEndpointNetworkPolicies = privateEndpointNetworkPolicies;
        return this;
    }

    /**
     * Get the privateLinkServiceNetworkPolicies property: Enable or Disable apply network policies on private link
     * service in the subnet.
     * 
     * @return the privateLinkServiceNetworkPolicies value.
     */
    public VirtualNetworkPrivateLinkServiceNetworkPolicies privateLinkServiceNetworkPolicies() {
        return this.privateLinkServiceNetworkPolicies;
    }

    /**
     * Set the privateLinkServiceNetworkPolicies property: Enable or Disable apply network policies on private link
     * service in the subnet.
     * 
     * @param privateLinkServiceNetworkPolicies the privateLinkServiceNetworkPolicies value to set.
     * @return the SubnetPropertiesFormatInner object itself.
     */
    public SubnetPropertiesFormatInner withPrivateLinkServiceNetworkPolicies(
        VirtualNetworkPrivateLinkServiceNetworkPolicies privateLinkServiceNetworkPolicies) {
        this.privateLinkServiceNetworkPolicies = privateLinkServiceNetworkPolicies;
        return this;
    }

    /**
     * Get the applicationGatewayIpConfigurations property: Application gateway IP configurations of virtual network
     * resource.
     * 
     * @return the applicationGatewayIpConfigurations value.
     */
    public List<ApplicationGatewayIpConfigurationInner> applicationGatewayIpConfigurations() {
        return this.applicationGatewayIpConfigurations;
    }

    /**
     * Set the applicationGatewayIpConfigurations property: Application gateway IP configurations of virtual network
     * resource.
     * 
     * @param applicationGatewayIpConfigurations the applicationGatewayIpConfigurations value to set.
     * @return the SubnetPropertiesFormatInner object itself.
     */
    public SubnetPropertiesFormatInner withApplicationGatewayIpConfigurations(
        List<ApplicationGatewayIpConfigurationInner> applicationGatewayIpConfigurations) {
        this.applicationGatewayIpConfigurations = applicationGatewayIpConfigurations;
        return this;
    }

    /**
     * Get the sharingScope property: Set this property to Tenant to allow sharing subnet with other subscriptions in
     * your AAD tenant. This property can only be set if defaultOutboundAccess is set to false, both properties can only
     * be set if subnet is empty.
     * 
     * @return the sharingScope value.
     */
    public SharingScope sharingScope() {
        return this.sharingScope;
    }

    /**
     * Set the sharingScope property: Set this property to Tenant to allow sharing subnet with other subscriptions in
     * your AAD tenant. This property can only be set if defaultOutboundAccess is set to false, both properties can only
     * be set if subnet is empty.
     * 
     * @param sharingScope the sharingScope value to set.
     * @return the SubnetPropertiesFormatInner object itself.
     */
    public SubnetPropertiesFormatInner withSharingScope(SharingScope sharingScope) {
        this.sharingScope = sharingScope;
        return this;
    }

    /**
     * Get the defaultOutboundAccess property: Set this property to false to disable default outbound connectivity for
     * all VMs in the subnet. This property can only be set at the time of subnet creation and cannot be updated for an
     * existing subnet.
     * 
     * @return the defaultOutboundAccess value.
     */
    public Boolean defaultOutboundAccess() {
        return this.defaultOutboundAccess;
    }

    /**
     * Set the defaultOutboundAccess property: Set this property to false to disable default outbound connectivity for
     * all VMs in the subnet. This property can only be set at the time of subnet creation and cannot be updated for an
     * existing subnet.
     * 
     * @param defaultOutboundAccess the defaultOutboundAccess value to set.
     * @return the SubnetPropertiesFormatInner object itself.
     */
    public SubnetPropertiesFormatInner withDefaultOutboundAccess(Boolean defaultOutboundAccess) {
        this.defaultOutboundAccess = defaultOutboundAccess;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkSecurityGroup() != null) {
            networkSecurityGroup().validate();
        }
        if (routeTable() != null) {
            routeTable().validate();
        }
        if (serviceEndpoints() != null) {
            serviceEndpoints().forEach(e -> e.validate());
        }
        if (serviceEndpointPolicies() != null) {
            serviceEndpointPolicies().forEach(e -> e.validate());
        }
        if (privateEndpoints() != null) {
            privateEndpoints().forEach(e -> e.validate());
        }
        if (ipConfigurations() != null) {
            ipConfigurations().forEach(e -> e.validate());
        }
        if (ipConfigurationProfiles() != null) {
            ipConfigurationProfiles().forEach(e -> e.validate());
        }
        if (resourceNavigationLinks() != null) {
            resourceNavigationLinks().forEach(e -> e.validate());
        }
        if (serviceAssociationLinks() != null) {
            serviceAssociationLinks().forEach(e -> e.validate());
        }
        if (delegations() != null) {
            delegations().forEach(e -> e.validate());
        }
        if (applicationGatewayIpConfigurations() != null) {
            applicationGatewayIpConfigurations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("addressPrefix", this.addressPrefix);
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("networkSecurityGroup", this.networkSecurityGroup);
        jsonWriter.writeJsonField("routeTable", this.routeTable);
        jsonWriter.writeJsonField("natGateway", this.natGateway);
        jsonWriter.writeArrayField("serviceEndpoints", this.serviceEndpoints,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("serviceEndpointPolicies", this.serviceEndpointPolicies,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("ipAllocations", this.ipAllocations, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("delegations", this.delegations, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("privateEndpointNetworkPolicies",
            this.privateEndpointNetworkPolicies == null ? null : this.privateEndpointNetworkPolicies.toString());
        jsonWriter.writeStringField("privateLinkServiceNetworkPolicies",
            this.privateLinkServiceNetworkPolicies == null ? null : this.privateLinkServiceNetworkPolicies.toString());
        jsonWriter.writeArrayField("applicationGatewayIPConfigurations", this.applicationGatewayIpConfigurations,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("sharingScope", this.sharingScope == null ? null : this.sharingScope.toString());
        jsonWriter.writeBooleanField("defaultOutboundAccess", this.defaultOutboundAccess);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SubnetPropertiesFormatInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SubnetPropertiesFormatInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SubnetPropertiesFormatInner.
     */
    public static SubnetPropertiesFormatInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SubnetPropertiesFormatInner deserializedSubnetPropertiesFormatInner = new SubnetPropertiesFormatInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("addressPrefix".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.addressPrefix = reader.getString();
                } else if ("addressPrefixes".equals(fieldName)) {
                    List<String> addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedSubnetPropertiesFormatInner.addressPrefixes = addressPrefixes;
                } else if ("networkSecurityGroup".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.networkSecurityGroup
                        = NetworkSecurityGroupInner.fromJson(reader);
                } else if ("routeTable".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.routeTable = RouteTableInner.fromJson(reader);
                } else if ("natGateway".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.natGateway = SubResource.fromJson(reader);
                } else if ("serviceEndpoints".equals(fieldName)) {
                    List<ServiceEndpointPropertiesFormat> serviceEndpoints
                        = reader.readArray(reader1 -> ServiceEndpointPropertiesFormat.fromJson(reader1));
                    deserializedSubnetPropertiesFormatInner.serviceEndpoints = serviceEndpoints;
                } else if ("serviceEndpointPolicies".equals(fieldName)) {
                    List<ServiceEndpointPolicyInner> serviceEndpointPolicies
                        = reader.readArray(reader1 -> ServiceEndpointPolicyInner.fromJson(reader1));
                    deserializedSubnetPropertiesFormatInner.serviceEndpointPolicies = serviceEndpointPolicies;
                } else if ("privateEndpoints".equals(fieldName)) {
                    List<PrivateEndpointInner> privateEndpoints
                        = reader.readArray(reader1 -> PrivateEndpointInner.fromJson(reader1));
                    deserializedSubnetPropertiesFormatInner.privateEndpoints = privateEndpoints;
                } else if ("ipConfigurations".equals(fieldName)) {
                    List<IpConfigurationInner> ipConfigurations
                        = reader.readArray(reader1 -> IpConfigurationInner.fromJson(reader1));
                    deserializedSubnetPropertiesFormatInner.ipConfigurations = ipConfigurations;
                } else if ("ipConfigurationProfiles".equals(fieldName)) {
                    List<IpConfigurationProfileInner> ipConfigurationProfiles
                        = reader.readArray(reader1 -> IpConfigurationProfileInner.fromJson(reader1));
                    deserializedSubnetPropertiesFormatInner.ipConfigurationProfiles = ipConfigurationProfiles;
                } else if ("ipAllocations".equals(fieldName)) {
                    List<SubResource> ipAllocations = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedSubnetPropertiesFormatInner.ipAllocations = ipAllocations;
                } else if ("resourceNavigationLinks".equals(fieldName)) {
                    List<ResourceNavigationLink> resourceNavigationLinks
                        = reader.readArray(reader1 -> ResourceNavigationLink.fromJson(reader1));
                    deserializedSubnetPropertiesFormatInner.resourceNavigationLinks = resourceNavigationLinks;
                } else if ("serviceAssociationLinks".equals(fieldName)) {
                    List<ServiceAssociationLink> serviceAssociationLinks
                        = reader.readArray(reader1 -> ServiceAssociationLink.fromJson(reader1));
                    deserializedSubnetPropertiesFormatInner.serviceAssociationLinks = serviceAssociationLinks;
                } else if ("delegations".equals(fieldName)) {
                    List<Delegation> delegations = reader.readArray(reader1 -> Delegation.fromJson(reader1));
                    deserializedSubnetPropertiesFormatInner.delegations = delegations;
                } else if ("purpose".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.purpose = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("privateEndpointNetworkPolicies".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.privateEndpointNetworkPolicies
                        = VirtualNetworkPrivateEndpointNetworkPolicies.fromString(reader.getString());
                } else if ("privateLinkServiceNetworkPolicies".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.privateLinkServiceNetworkPolicies
                        = VirtualNetworkPrivateLinkServiceNetworkPolicies.fromString(reader.getString());
                } else if ("applicationGatewayIPConfigurations".equals(fieldName)) {
                    List<ApplicationGatewayIpConfigurationInner> applicationGatewayIpConfigurations
                        = reader.readArray(reader1 -> ApplicationGatewayIpConfigurationInner.fromJson(reader1));
                    deserializedSubnetPropertiesFormatInner.applicationGatewayIpConfigurations
                        = applicationGatewayIpConfigurations;
                } else if ("sharingScope".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.sharingScope = SharingScope.fromString(reader.getString());
                } else if ("defaultOutboundAccess".equals(fieldName)) {
                    deserializedSubnetPropertiesFormatInner.defaultOutboundAccess
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSubnetPropertiesFormatInner;
        });
    }
}
