// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Response for the ListServiceTags API service call.
 */
@Immutable
public final class ServiceTagsListResultInner implements JsonSerializable<ServiceTagsListResultInner> {
    /*
     * The name of the cloud.
     */
    private String name;

    /*
     * The ID of the cloud.
     */
    private String id;

    /*
     * The azure resource type.
     */
    private String type;

    /*
     * The iteration number.
     */
    private String changeNumber;

    /*
     * The name of the cloud.
     */
    private String cloud;

    /*
     * The list of service tag information resources.
     */
    private List<ServiceTagInformationInner> values;

    /*
     * The URL to get next page of service tag information resources.
     */
    private String nextLink;

    /**
     * Creates an instance of ServiceTagsListResultInner class.
     */
    public ServiceTagsListResultInner() {
    }

    /**
     * Get the name property: The name of the cloud.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: The ID of the cloud.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the type property: The azure resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the changeNumber property: The iteration number.
     * 
     * @return the changeNumber value.
     */
    public String changeNumber() {
        return this.changeNumber;
    }

    /**
     * Get the cloud property: The name of the cloud.
     * 
     * @return the cloud value.
     */
    public String cloud() {
        return this.cloud;
    }

    /**
     * Get the values property: The list of service tag information resources.
     * 
     * @return the values value.
     */
    public List<ServiceTagInformationInner> values() {
        return this.values;
    }

    /**
     * Get the nextLink property: The URL to get next page of service tag information resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (values() != null) {
            values().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServiceTagsListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServiceTagsListResultInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServiceTagsListResultInner.
     */
    public static ServiceTagsListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceTagsListResultInner deserializedServiceTagsListResultInner = new ServiceTagsListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedServiceTagsListResultInner.name = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedServiceTagsListResultInner.id = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedServiceTagsListResultInner.type = reader.getString();
                } else if ("changeNumber".equals(fieldName)) {
                    deserializedServiceTagsListResultInner.changeNumber = reader.getString();
                } else if ("cloud".equals(fieldName)) {
                    deserializedServiceTagsListResultInner.cloud = reader.getString();
                } else if ("values".equals(fieldName)) {
                    List<ServiceTagInformationInner> values
                        = reader.readArray(reader1 -> ServiceTagInformationInner.fromJson(reader1));
                    deserializedServiceTagsListResultInner.values = values;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedServiceTagsListResultInner.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServiceTagsListResultInner;
        });
    }
}
