// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Service Endpoint policy definition resource.
 */
@Fluent
public final class ServiceEndpointPolicyDefinitionPropertiesFormat
    implements JsonSerializable<ServiceEndpointPolicyDefinitionPropertiesFormat> {
    /*
     * A description for this rule. Restricted to 140 chars.
     */
    private String description;

    /*
     * Service endpoint name.
     */
    private String service;

    /*
     * A list of service resources.
     */
    private List<String> serviceResources;

    /*
     * The provisioning state of the service endpoint policy definition resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ServiceEndpointPolicyDefinitionPropertiesFormat class.
     */
    public ServiceEndpointPolicyDefinitionPropertiesFormat() {
    }

    /**
     * Get the description property: A description for this rule. Restricted to 140 chars.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A description for this rule. Restricted to 140 chars.
     * 
     * @param description the description value to set.
     * @return the ServiceEndpointPolicyDefinitionPropertiesFormat object itself.
     */
    public ServiceEndpointPolicyDefinitionPropertiesFormat withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the service property: Service endpoint name.
     * 
     * @return the service value.
     */
    public String service() {
        return this.service;
    }

    /**
     * Set the service property: Service endpoint name.
     * 
     * @param service the service value to set.
     * @return the ServiceEndpointPolicyDefinitionPropertiesFormat object itself.
     */
    public ServiceEndpointPolicyDefinitionPropertiesFormat withService(String service) {
        this.service = service;
        return this;
    }

    /**
     * Get the serviceResources property: A list of service resources.
     * 
     * @return the serviceResources value.
     */
    public List<String> serviceResources() {
        return this.serviceResources;
    }

    /**
     * Set the serviceResources property: A list of service resources.
     * 
     * @param serviceResources the serviceResources value to set.
     * @return the ServiceEndpointPolicyDefinitionPropertiesFormat object itself.
     */
    public ServiceEndpointPolicyDefinitionPropertiesFormat withServiceResources(List<String> serviceResources) {
        this.serviceResources = serviceResources;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the service endpoint policy definition resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("service", this.service);
        jsonWriter.writeArrayField("serviceResources", this.serviceResources,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServiceEndpointPolicyDefinitionPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServiceEndpointPolicyDefinitionPropertiesFormat if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServiceEndpointPolicyDefinitionPropertiesFormat.
     */
    public static ServiceEndpointPolicyDefinitionPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceEndpointPolicyDefinitionPropertiesFormat deserializedServiceEndpointPolicyDefinitionPropertiesFormat
                = new ServiceEndpointPolicyDefinitionPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedServiceEndpointPolicyDefinitionPropertiesFormat.description = reader.getString();
                } else if ("service".equals(fieldName)) {
                    deserializedServiceEndpointPolicyDefinitionPropertiesFormat.service = reader.getString();
                } else if ("serviceResources".equals(fieldName)) {
                    List<String> serviceResources = reader.readArray(reader1 -> reader1.getString());
                    deserializedServiceEndpointPolicyDefinitionPropertiesFormat.serviceResources = serviceResources;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedServiceEndpointPolicyDefinitionPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServiceEndpointPolicyDefinitionPropertiesFormat;
        });
    }
}
