// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.SecurityGroupNetworkInterface;
import java.io.IOException;
import java.util.List;

/**
 * The information about security rules applied to the specified VM.
 */
@Fluent
public final class SecurityGroupViewResultInner implements JsonSerializable<SecurityGroupViewResultInner> {
    /*
     * List of network interfaces on the specified VM.
     */
    private List<SecurityGroupNetworkInterface> networkInterfaces;

    /**
     * Creates an instance of SecurityGroupViewResultInner class.
     */
    public SecurityGroupViewResultInner() {
    }

    /**
     * Get the networkInterfaces property: List of network interfaces on the specified VM.
     * 
     * @return the networkInterfaces value.
     */
    public List<SecurityGroupNetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    /**
     * Set the networkInterfaces property: List of network interfaces on the specified VM.
     * 
     * @param networkInterfaces the networkInterfaces value to set.
     * @return the SecurityGroupViewResultInner object itself.
     */
    public SecurityGroupViewResultInner withNetworkInterfaces(List<SecurityGroupNetworkInterface> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkInterfaces() != null) {
            networkInterfaces().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("networkInterfaces", this.networkInterfaces,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityGroupViewResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityGroupViewResultInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecurityGroupViewResultInner.
     */
    public static SecurityGroupViewResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityGroupViewResultInner deserializedSecurityGroupViewResultInner = new SecurityGroupViewResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("networkInterfaces".equals(fieldName)) {
                    List<SecurityGroupNetworkInterface> networkInterfaces
                        = reader.readArray(reader1 -> SecurityGroupNetworkInterface.fromJson(reader1));
                    deserializedSecurityGroupViewResultInner.networkInterfaces = networkInterfaces;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityGroupViewResultInner;
        });
    }
}
