// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConfigurationType;
import com.azure.resourcemanager.network.models.NetworkManagerPropertiesNetworkManagerScopes;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Properties of Managed Network.
 */
@Fluent
public final class NetworkManagerProperties implements JsonSerializable<NetworkManagerProperties> {
    /*
     * A description of the network manager.
     */
    private String description;

    /*
     * Scope of Network Manager.
     */
    private NetworkManagerPropertiesNetworkManagerScopes networkManagerScopes;

    /*
     * Scope Access.
     */
    private List<ConfigurationType> networkManagerScopeAccesses;

    /*
     * The provisioning state of the network manager resource.
     */
    private ProvisioningState provisioningState;

    /*
     * Unique identifier for this resource.
     */
    private String resourceGuid;

    /**
     * Creates an instance of NetworkManagerProperties class.
     */
    public NetworkManagerProperties() {
    }

    /**
     * Get the description property: A description of the network manager.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A description of the network manager.
     * 
     * @param description the description value to set.
     * @return the NetworkManagerProperties object itself.
     */
    public NetworkManagerProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the networkManagerScopes property: Scope of Network Manager.
     * 
     * @return the networkManagerScopes value.
     */
    public NetworkManagerPropertiesNetworkManagerScopes networkManagerScopes() {
        return this.networkManagerScopes;
    }

    /**
     * Set the networkManagerScopes property: Scope of Network Manager.
     * 
     * @param networkManagerScopes the networkManagerScopes value to set.
     * @return the NetworkManagerProperties object itself.
     */
    public NetworkManagerProperties
        withNetworkManagerScopes(NetworkManagerPropertiesNetworkManagerScopes networkManagerScopes) {
        this.networkManagerScopes = networkManagerScopes;
        return this;
    }

    /**
     * Get the networkManagerScopeAccesses property: Scope Access.
     * 
     * @return the networkManagerScopeAccesses value.
     */
    public List<ConfigurationType> networkManagerScopeAccesses() {
        return this.networkManagerScopeAccesses;
    }

    /**
     * Set the networkManagerScopeAccesses property: Scope Access.
     * 
     * @param networkManagerScopeAccesses the networkManagerScopeAccesses value to set.
     * @return the NetworkManagerProperties object itself.
     */
    public NetworkManagerProperties
        withNetworkManagerScopeAccesses(List<ConfigurationType> networkManagerScopeAccesses) {
        this.networkManagerScopeAccesses = networkManagerScopeAccesses;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the network manager resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the resourceGuid property: Unique identifier for this resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkManagerScopes() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property networkManagerScopes in model NetworkManagerProperties"));
        } else {
            networkManagerScopes().validate();
        }
        if (networkManagerScopeAccesses() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property networkManagerScopeAccesses in model NetworkManagerProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(NetworkManagerProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("networkManagerScopes", this.networkManagerScopes);
        jsonWriter.writeArrayField("networkManagerScopeAccesses", this.networkManagerScopeAccesses,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkManagerProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkManagerProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NetworkManagerProperties.
     */
    public static NetworkManagerProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkManagerProperties deserializedNetworkManagerProperties = new NetworkManagerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("networkManagerScopes".equals(fieldName)) {
                    deserializedNetworkManagerProperties.networkManagerScopes
                        = NetworkManagerPropertiesNetworkManagerScopes.fromJson(reader);
                } else if ("networkManagerScopeAccesses".equals(fieldName)) {
                    List<ConfigurationType> networkManagerScopeAccesses
                        = reader.readArray(reader1 -> ConfigurationType.fromString(reader1.getString()));
                    deserializedNetworkManagerProperties.networkManagerScopeAccesses = networkManagerScopeAccesses;
                } else if ("description".equals(fieldName)) {
                    deserializedNetworkManagerProperties.description = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkManagerProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("resourceGuid".equals(fieldName)) {
                    deserializedNetworkManagerProperties.resourceGuid = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkManagerProperties;
        });
    }
}
