// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.EffectiveBaseSecurityAdminRule;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list networkManagerEffectiveSecurityAdminRules. It contains a list of groups and a skiptoken
 * to get the next set of results.
 */
@Fluent
public final class NetworkManagerEffectiveSecurityAdminRulesListResultInner
    implements JsonSerializable<NetworkManagerEffectiveSecurityAdminRulesListResultInner> {
    /*
     * Gets a page of NetworkManagerEffectiveSecurityAdminRules
     */
    private List<EffectiveBaseSecurityAdminRule> value;

    /*
     * When present, the value can be passed to a subsequent query call (together with the same query and scopes used in
     * the current request) to retrieve the next page of data.
     */
    private String skipToken;

    /**
     * Creates an instance of NetworkManagerEffectiveSecurityAdminRulesListResultInner class.
     */
    public NetworkManagerEffectiveSecurityAdminRulesListResultInner() {
    }

    /**
     * Get the value property: Gets a page of NetworkManagerEffectiveSecurityAdminRules.
     * 
     * @return the value value.
     */
    public List<EffectiveBaseSecurityAdminRule> value() {
        return this.value;
    }

    /**
     * Set the value property: Gets a page of NetworkManagerEffectiveSecurityAdminRules.
     * 
     * @param value the value value to set.
     * @return the NetworkManagerEffectiveSecurityAdminRulesListResultInner object itself.
     */
    public NetworkManagerEffectiveSecurityAdminRulesListResultInner
        withValue(List<EffectiveBaseSecurityAdminRule> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the skipToken property: When present, the value can be passed to a subsequent query call (together with the
     * same query and scopes used in the current request) to retrieve the next page of data.
     * 
     * @return the skipToken value.
     */
    public String skipToken() {
        return this.skipToken;
    }

    /**
     * Set the skipToken property: When present, the value can be passed to a subsequent query call (together with the
     * same query and scopes used in the current request) to retrieve the next page of data.
     * 
     * @param skipToken the skipToken value to set.
     * @return the NetworkManagerEffectiveSecurityAdminRulesListResultInner object itself.
     */
    public NetworkManagerEffectiveSecurityAdminRulesListResultInner withSkipToken(String skipToken) {
        this.skipToken = skipToken;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("skipToken", this.skipToken);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkManagerEffectiveSecurityAdminRulesListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkManagerEffectiveSecurityAdminRulesListResultInner if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * NetworkManagerEffectiveSecurityAdminRulesListResultInner.
     */
    public static NetworkManagerEffectiveSecurityAdminRulesListResultInner fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkManagerEffectiveSecurityAdminRulesListResultInner deserializedNetworkManagerEffectiveSecurityAdminRulesListResultInner
                = new NetworkManagerEffectiveSecurityAdminRulesListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<EffectiveBaseSecurityAdminRule> value
                        = reader.readArray(reader1 -> EffectiveBaseSecurityAdminRule.fromJson(reader1));
                    deserializedNetworkManagerEffectiveSecurityAdminRulesListResultInner.value = value;
                } else if ("skipToken".equals(fieldName)) {
                    deserializedNetworkManagerEffectiveSecurityAdminRulesListResultInner.skipToken = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkManagerEffectiveSecurityAdminRulesListResultInner;
        });
    }
}
