// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendAddressPool;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.NetworkInterfaceIpConfigurationPrivateLinkConnectionProperties;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Properties of IP configuration.
 */
@Fluent
public final class NetworkInterfaceIpConfigurationPropertiesFormatInner
    implements JsonSerializable<NetworkInterfaceIpConfigurationPropertiesFormatInner> {
    /*
     * The reference to gateway load balancer frontend IP.
     */
    private SubResource gatewayLoadBalancer;

    /*
     * The reference to Virtual Network Taps.
     */
    private List<VirtualNetworkTapInner> virtualNetworkTaps;

    /*
     * The reference to ApplicationGatewayBackendAddressPool resource.
     */
    private List<ApplicationGatewayBackendAddressPool> applicationGatewayBackendAddressPools;

    /*
     * The reference to LoadBalancerBackendAddressPool resource.
     */
    private List<BackendAddressPoolInner> loadBalancerBackendAddressPools;

    /*
     * A list of references of LoadBalancerInboundNatRules.
     */
    private List<InboundNatRuleInner> loadBalancerInboundNatRules;

    /*
     * Private IP address of the IP configuration. It can be a single IP address or a CIDR block in the format
     * <address>/<prefix-length>.
     */
    private String privateIpAddress;

    /*
     * The private IP address prefix length. If specified and the allocation method is dynamic, the service will
     * allocate a CIDR block instead of a single IP address.
     */
    private Integer privateIpAddressPrefixLength;

    /*
     * The private IP address allocation method.
     */
    private IpAllocationMethod privateIpAllocationMethod;

    /*
     * Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
     */
    private IpVersion privateIpAddressVersion;

    /*
     * Subnet bound to the IP configuration.
     */
    private SubnetInner subnet;

    /*
     * Whether this is a primary customer address on the network interface.
     */
    private Boolean primary;

    /*
     * Public IP address bound to the IP configuration.
     */
    private PublicIpAddressInner publicIpAddress;

    /*
     * Application security groups in which the IP configuration is included.
     */
    private List<ApplicationSecurityGroupInner> applicationSecurityGroups;

    /*
     * The provisioning state of the network interface IP configuration.
     */
    private ProvisioningState provisioningState;

    /*
     * PrivateLinkConnection properties for the network interface.
     */
    private NetworkInterfaceIpConfigurationPrivateLinkConnectionProperties privateLinkConnectionProperties;

    /**
     * Creates an instance of NetworkInterfaceIpConfigurationPropertiesFormatInner class.
     */
    public NetworkInterfaceIpConfigurationPropertiesFormatInner() {
    }

    /**
     * Get the gatewayLoadBalancer property: The reference to gateway load balancer frontend IP.
     * 
     * @return the gatewayLoadBalancer value.
     */
    public SubResource gatewayLoadBalancer() {
        return this.gatewayLoadBalancer;
    }

    /**
     * Set the gatewayLoadBalancer property: The reference to gateway load balancer frontend IP.
     * 
     * @param gatewayLoadBalancer the gatewayLoadBalancer value to set.
     * @return the NetworkInterfaceIpConfigurationPropertiesFormatInner object itself.
     */
    public NetworkInterfaceIpConfigurationPropertiesFormatInner
        withGatewayLoadBalancer(SubResource gatewayLoadBalancer) {
        this.gatewayLoadBalancer = gatewayLoadBalancer;
        return this;
    }

    /**
     * Get the virtualNetworkTaps property: The reference to Virtual Network Taps.
     * 
     * @return the virtualNetworkTaps value.
     */
    public List<VirtualNetworkTapInner> virtualNetworkTaps() {
        return this.virtualNetworkTaps;
    }

    /**
     * Set the virtualNetworkTaps property: The reference to Virtual Network Taps.
     * 
     * @param virtualNetworkTaps the virtualNetworkTaps value to set.
     * @return the NetworkInterfaceIpConfigurationPropertiesFormatInner object itself.
     */
    public NetworkInterfaceIpConfigurationPropertiesFormatInner
        withVirtualNetworkTaps(List<VirtualNetworkTapInner> virtualNetworkTaps) {
        this.virtualNetworkTaps = virtualNetworkTaps;
        return this;
    }

    /**
     * Get the applicationGatewayBackendAddressPools property: The reference to ApplicationGatewayBackendAddressPool
     * resource.
     * 
     * @return the applicationGatewayBackendAddressPools value.
     */
    public List<ApplicationGatewayBackendAddressPool> applicationGatewayBackendAddressPools() {
        return this.applicationGatewayBackendAddressPools;
    }

    /**
     * Set the applicationGatewayBackendAddressPools property: The reference to ApplicationGatewayBackendAddressPool
     * resource.
     * 
     * @param applicationGatewayBackendAddressPools the applicationGatewayBackendAddressPools value to set.
     * @return the NetworkInterfaceIpConfigurationPropertiesFormatInner object itself.
     */
    public NetworkInterfaceIpConfigurationPropertiesFormatInner withApplicationGatewayBackendAddressPools(
        List<ApplicationGatewayBackendAddressPool> applicationGatewayBackendAddressPools) {
        this.applicationGatewayBackendAddressPools = applicationGatewayBackendAddressPools;
        return this;
    }

    /**
     * Get the loadBalancerBackendAddressPools property: The reference to LoadBalancerBackendAddressPool resource.
     * 
     * @return the loadBalancerBackendAddressPools value.
     */
    public List<BackendAddressPoolInner> loadBalancerBackendAddressPools() {
        return this.loadBalancerBackendAddressPools;
    }

    /**
     * Set the loadBalancerBackendAddressPools property: The reference to LoadBalancerBackendAddressPool resource.
     * 
     * @param loadBalancerBackendAddressPools the loadBalancerBackendAddressPools value to set.
     * @return the NetworkInterfaceIpConfigurationPropertiesFormatInner object itself.
     */
    public NetworkInterfaceIpConfigurationPropertiesFormatInner
        withLoadBalancerBackendAddressPools(List<BackendAddressPoolInner> loadBalancerBackendAddressPools) {
        this.loadBalancerBackendAddressPools = loadBalancerBackendAddressPools;
        return this;
    }

    /**
     * Get the loadBalancerInboundNatRules property: A list of references of LoadBalancerInboundNatRules.
     * 
     * @return the loadBalancerInboundNatRules value.
     */
    public List<InboundNatRuleInner> loadBalancerInboundNatRules() {
        return this.loadBalancerInboundNatRules;
    }

    /**
     * Set the loadBalancerInboundNatRules property: A list of references of LoadBalancerInboundNatRules.
     * 
     * @param loadBalancerInboundNatRules the loadBalancerInboundNatRules value to set.
     * @return the NetworkInterfaceIpConfigurationPropertiesFormatInner object itself.
     */
    public NetworkInterfaceIpConfigurationPropertiesFormatInner
        withLoadBalancerInboundNatRules(List<InboundNatRuleInner> loadBalancerInboundNatRules) {
        this.loadBalancerInboundNatRules = loadBalancerInboundNatRules;
        return this;
    }

    /**
     * Get the privateIpAddress property: Private IP address of the IP configuration. It can be a single IP address or a
     * CIDR block in the format &lt;address&gt;/&lt;prefix-length&gt;.
     * 
     * @return the privateIpAddress value.
     */
    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    /**
     * Set the privateIpAddress property: Private IP address of the IP configuration. It can be a single IP address or a
     * CIDR block in the format &lt;address&gt;/&lt;prefix-length&gt;.
     * 
     * @param privateIpAddress the privateIpAddress value to set.
     * @return the NetworkInterfaceIpConfigurationPropertiesFormatInner object itself.
     */
    public NetworkInterfaceIpConfigurationPropertiesFormatInner withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    /**
     * Get the privateIpAddressPrefixLength property: The private IP address prefix length. If specified and the
     * allocation method is dynamic, the service will allocate a CIDR block instead of a single IP address.
     * 
     * @return the privateIpAddressPrefixLength value.
     */
    public Integer privateIpAddressPrefixLength() {
        return this.privateIpAddressPrefixLength;
    }

    /**
     * Set the privateIpAddressPrefixLength property: The private IP address prefix length. If specified and the
     * allocation method is dynamic, the service will allocate a CIDR block instead of a single IP address.
     * 
     * @param privateIpAddressPrefixLength the privateIpAddressPrefixLength value to set.
     * @return the NetworkInterfaceIpConfigurationPropertiesFormatInner object itself.
     */
    public NetworkInterfaceIpConfigurationPropertiesFormatInner
        withPrivateIpAddressPrefixLength(Integer privateIpAddressPrefixLength) {
        this.privateIpAddressPrefixLength = privateIpAddressPrefixLength;
        return this;
    }

    /**
     * Get the privateIpAllocationMethod property: The private IP address allocation method.
     * 
     * @return the privateIpAllocationMethod value.
     */
    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    /**
     * Set the privateIpAllocationMethod property: The private IP address allocation method.
     * 
     * @param privateIpAllocationMethod the privateIpAllocationMethod value to set.
     * @return the NetworkInterfaceIpConfigurationPropertiesFormatInner object itself.
     */
    public NetworkInterfaceIpConfigurationPropertiesFormatInner
        withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    /**
     * Get the privateIpAddressVersion property: Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
     * 
     * @return the privateIpAddressVersion value.
     */
    public IpVersion privateIpAddressVersion() {
        return this.privateIpAddressVersion;
    }

    /**
     * Set the privateIpAddressVersion property: Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
     * 
     * @param privateIpAddressVersion the privateIpAddressVersion value to set.
     * @return the NetworkInterfaceIpConfigurationPropertiesFormatInner object itself.
     */
    public NetworkInterfaceIpConfigurationPropertiesFormatInner
        withPrivateIpAddressVersion(IpVersion privateIpAddressVersion) {
        this.privateIpAddressVersion = privateIpAddressVersion;
        return this;
    }

    /**
     * Get the subnet property: Subnet bound to the IP configuration.
     * 
     * @return the subnet value.
     */
    public SubnetInner subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: Subnet bound to the IP configuration.
     * 
     * @param subnet the subnet value to set.
     * @return the NetworkInterfaceIpConfigurationPropertiesFormatInner object itself.
     */
    public NetworkInterfaceIpConfigurationPropertiesFormatInner withSubnet(SubnetInner subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the primary property: Whether this is a primary customer address on the network interface.
     * 
     * @return the primary value.
     */
    public Boolean primary() {
        return this.primary;
    }

    /**
     * Set the primary property: Whether this is a primary customer address on the network interface.
     * 
     * @param primary the primary value to set.
     * @return the NetworkInterfaceIpConfigurationPropertiesFormatInner object itself.
     */
    public NetworkInterfaceIpConfigurationPropertiesFormatInner withPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    /**
     * Get the publicIpAddress property: Public IP address bound to the IP configuration.
     * 
     * @return the publicIpAddress value.
     */
    public PublicIpAddressInner publicIpAddress() {
        return this.publicIpAddress;
    }

    /**
     * Set the publicIpAddress property: Public IP address bound to the IP configuration.
     * 
     * @param publicIpAddress the publicIpAddress value to set.
     * @return the NetworkInterfaceIpConfigurationPropertiesFormatInner object itself.
     */
    public NetworkInterfaceIpConfigurationPropertiesFormatInner
        withPublicIpAddress(PublicIpAddressInner publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    /**
     * Get the applicationSecurityGroups property: Application security groups in which the IP configuration is
     * included.
     * 
     * @return the applicationSecurityGroups value.
     */
    public List<ApplicationSecurityGroupInner> applicationSecurityGroups() {
        return this.applicationSecurityGroups;
    }

    /**
     * Set the applicationSecurityGroups property: Application security groups in which the IP configuration is
     * included.
     * 
     * @param applicationSecurityGroups the applicationSecurityGroups value to set.
     * @return the NetworkInterfaceIpConfigurationPropertiesFormatInner object itself.
     */
    public NetworkInterfaceIpConfigurationPropertiesFormatInner
        withApplicationSecurityGroups(List<ApplicationSecurityGroupInner> applicationSecurityGroups) {
        this.applicationSecurityGroups = applicationSecurityGroups;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the network interface IP configuration.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the privateLinkConnectionProperties property: PrivateLinkConnection properties for the network interface.
     * 
     * @return the privateLinkConnectionProperties value.
     */
    public NetworkInterfaceIpConfigurationPrivateLinkConnectionProperties privateLinkConnectionProperties() {
        return this.privateLinkConnectionProperties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (virtualNetworkTaps() != null) {
            virtualNetworkTaps().forEach(e -> e.validate());
        }
        if (applicationGatewayBackendAddressPools() != null) {
            applicationGatewayBackendAddressPools().forEach(e -> e.validate());
        }
        if (loadBalancerBackendAddressPools() != null) {
            loadBalancerBackendAddressPools().forEach(e -> e.validate());
        }
        if (loadBalancerInboundNatRules() != null) {
            loadBalancerInboundNatRules().forEach(e -> e.validate());
        }
        if (subnet() != null) {
            subnet().validate();
        }
        if (publicIpAddress() != null) {
            publicIpAddress().validate();
        }
        if (applicationSecurityGroups() != null) {
            applicationSecurityGroups().forEach(e -> e.validate());
        }
        if (privateLinkConnectionProperties() != null) {
            privateLinkConnectionProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("gatewayLoadBalancer", this.gatewayLoadBalancer);
        jsonWriter.writeArrayField("virtualNetworkTaps", this.virtualNetworkTaps,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("applicationGatewayBackendAddressPools", this.applicationGatewayBackendAddressPools,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("loadBalancerBackendAddressPools", this.loadBalancerBackendAddressPools,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("loadBalancerInboundNatRules", this.loadBalancerInboundNatRules,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("privateIPAddress", this.privateIpAddress);
        jsonWriter.writeNumberField("privateIPAddressPrefixLength", this.privateIpAddressPrefixLength);
        jsonWriter.writeStringField("privateIPAllocationMethod",
            this.privateIpAllocationMethod == null ? null : this.privateIpAllocationMethod.toString());
        jsonWriter.writeStringField("privateIPAddressVersion",
            this.privateIpAddressVersion == null ? null : this.privateIpAddressVersion.toString());
        jsonWriter.writeJsonField("subnet", this.subnet);
        jsonWriter.writeBooleanField("primary", this.primary);
        jsonWriter.writeJsonField("publicIPAddress", this.publicIpAddress);
        jsonWriter.writeArrayField("applicationSecurityGroups", this.applicationSecurityGroups,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkInterfaceIpConfigurationPropertiesFormatInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkInterfaceIpConfigurationPropertiesFormatInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkInterfaceIpConfigurationPropertiesFormatInner.
     */
    public static NetworkInterfaceIpConfigurationPropertiesFormatInner fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkInterfaceIpConfigurationPropertiesFormatInner deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner
                = new NetworkInterfaceIpConfigurationPropertiesFormatInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("gatewayLoadBalancer".equals(fieldName)) {
                    deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner.gatewayLoadBalancer
                        = SubResource.fromJson(reader);
                } else if ("virtualNetworkTaps".equals(fieldName)) {
                    List<VirtualNetworkTapInner> virtualNetworkTaps
                        = reader.readArray(reader1 -> VirtualNetworkTapInner.fromJson(reader1));
                    deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner.virtualNetworkTaps
                        = virtualNetworkTaps;
                } else if ("applicationGatewayBackendAddressPools".equals(fieldName)) {
                    List<ApplicationGatewayBackendAddressPool> applicationGatewayBackendAddressPools
                        = reader.readArray(reader1 -> ApplicationGatewayBackendAddressPool.fromJson(reader1));
                    deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner.applicationGatewayBackendAddressPools
                        = applicationGatewayBackendAddressPools;
                } else if ("loadBalancerBackendAddressPools".equals(fieldName)) {
                    List<BackendAddressPoolInner> loadBalancerBackendAddressPools
                        = reader.readArray(reader1 -> BackendAddressPoolInner.fromJson(reader1));
                    deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner.loadBalancerBackendAddressPools
                        = loadBalancerBackendAddressPools;
                } else if ("loadBalancerInboundNatRules".equals(fieldName)) {
                    List<InboundNatRuleInner> loadBalancerInboundNatRules
                        = reader.readArray(reader1 -> InboundNatRuleInner.fromJson(reader1));
                    deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner.loadBalancerInboundNatRules
                        = loadBalancerInboundNatRules;
                } else if ("privateIPAddress".equals(fieldName)) {
                    deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner.privateIpAddress
                        = reader.getString();
                } else if ("privateIPAddressPrefixLength".equals(fieldName)) {
                    deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner.privateIpAddressPrefixLength
                        = reader.getNullable(JsonReader::getInt);
                } else if ("privateIPAllocationMethod".equals(fieldName)) {
                    deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner.privateIpAllocationMethod
                        = IpAllocationMethod.fromString(reader.getString());
                } else if ("privateIPAddressVersion".equals(fieldName)) {
                    deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner.privateIpAddressVersion
                        = IpVersion.fromString(reader.getString());
                } else if ("subnet".equals(fieldName)) {
                    deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner.subnet
                        = SubnetInner.fromJson(reader);
                } else if ("primary".equals(fieldName)) {
                    deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner.primary
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("publicIPAddress".equals(fieldName)) {
                    deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner.publicIpAddress
                        = PublicIpAddressInner.fromJson(reader);
                } else if ("applicationSecurityGroups".equals(fieldName)) {
                    List<ApplicationSecurityGroupInner> applicationSecurityGroups
                        = reader.readArray(reader1 -> ApplicationSecurityGroupInner.fromJson(reader1));
                    deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner.applicationSecurityGroups
                        = applicationSecurityGroups;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("privateLinkConnectionProperties".equals(fieldName)) {
                    deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner.privateLinkConnectionProperties
                        = NetworkInterfaceIpConfigurationPrivateLinkConnectionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkInterfaceIpConfigurationPropertiesFormatInner;
        });
    }
}
