// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingConfiguration;
import java.io.IOException;

/**
 * Parameters for HubVirtualNetworkConnection.
 */
@Fluent
public final class HubVirtualNetworkConnectionProperties
    implements JsonSerializable<HubVirtualNetworkConnectionProperties> {
    /*
     * Reference to the remote virtual network.
     */
    private SubResource remoteVirtualNetwork;

    /*
     * Deprecated: VirtualHub to RemoteVnet transit to enabled or not.
     */
    private Boolean allowHubToRemoteVnetTransit;

    /*
     * Deprecated: Allow RemoteVnet to use Virtual Hub's gateways.
     */
    private Boolean allowRemoteVnetToUseHubVnetGateways;

    /*
     * Enable internet security.
     */
    private Boolean enableInternetSecurity;

    /*
     * The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    private RoutingConfiguration routingConfiguration;

    /*
     * The provisioning state of the hub virtual network connection resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of HubVirtualNetworkConnectionProperties class.
     */
    public HubVirtualNetworkConnectionProperties() {
    }

    /**
     * Get the remoteVirtualNetwork property: Reference to the remote virtual network.
     * 
     * @return the remoteVirtualNetwork value.
     */
    public SubResource remoteVirtualNetwork() {
        return this.remoteVirtualNetwork;
    }

    /**
     * Set the remoteVirtualNetwork property: Reference to the remote virtual network.
     * 
     * @param remoteVirtualNetwork the remoteVirtualNetwork value to set.
     * @return the HubVirtualNetworkConnectionProperties object itself.
     */
    public HubVirtualNetworkConnectionProperties withRemoteVirtualNetwork(SubResource remoteVirtualNetwork) {
        this.remoteVirtualNetwork = remoteVirtualNetwork;
        return this;
    }

    /**
     * Get the allowHubToRemoteVnetTransit property: Deprecated: VirtualHub to RemoteVnet transit to enabled or not.
     * 
     * @return the allowHubToRemoteVnetTransit value.
     */
    public Boolean allowHubToRemoteVnetTransit() {
        return this.allowHubToRemoteVnetTransit;
    }

    /**
     * Set the allowHubToRemoteVnetTransit property: Deprecated: VirtualHub to RemoteVnet transit to enabled or not.
     * 
     * @param allowHubToRemoteVnetTransit the allowHubToRemoteVnetTransit value to set.
     * @return the HubVirtualNetworkConnectionProperties object itself.
     */
    public HubVirtualNetworkConnectionProperties withAllowHubToRemoteVnetTransit(Boolean allowHubToRemoteVnetTransit) {
        this.allowHubToRemoteVnetTransit = allowHubToRemoteVnetTransit;
        return this;
    }

    /**
     * Get the allowRemoteVnetToUseHubVnetGateways property: Deprecated: Allow RemoteVnet to use Virtual Hub's gateways.
     * 
     * @return the allowRemoteVnetToUseHubVnetGateways value.
     */
    public Boolean allowRemoteVnetToUseHubVnetGateways() {
        return this.allowRemoteVnetToUseHubVnetGateways;
    }

    /**
     * Set the allowRemoteVnetToUseHubVnetGateways property: Deprecated: Allow RemoteVnet to use Virtual Hub's gateways.
     * 
     * @param allowRemoteVnetToUseHubVnetGateways the allowRemoteVnetToUseHubVnetGateways value to set.
     * @return the HubVirtualNetworkConnectionProperties object itself.
     */
    public HubVirtualNetworkConnectionProperties
        withAllowRemoteVnetToUseHubVnetGateways(Boolean allowRemoteVnetToUseHubVnetGateways) {
        this.allowRemoteVnetToUseHubVnetGateways = allowRemoteVnetToUseHubVnetGateways;
        return this;
    }

    /**
     * Get the enableInternetSecurity property: Enable internet security.
     * 
     * @return the enableInternetSecurity value.
     */
    public Boolean enableInternetSecurity() {
        return this.enableInternetSecurity;
    }

    /**
     * Set the enableInternetSecurity property: Enable internet security.
     * 
     * @param enableInternetSecurity the enableInternetSecurity value to set.
     * @return the HubVirtualNetworkConnectionProperties object itself.
     */
    public HubVirtualNetworkConnectionProperties withEnableInternetSecurity(Boolean enableInternetSecurity) {
        this.enableInternetSecurity = enableInternetSecurity;
        return this;
    }

    /**
     * Get the routingConfiguration property: The Routing Configuration indicating the associated and propagated route
     * tables on this connection.
     * 
     * @return the routingConfiguration value.
     */
    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    /**
     * Set the routingConfiguration property: The Routing Configuration indicating the associated and propagated route
     * tables on this connection.
     * 
     * @param routingConfiguration the routingConfiguration value to set.
     * @return the HubVirtualNetworkConnectionProperties object itself.
     */
    public HubVirtualNetworkConnectionProperties withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the hub virtual network connection resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (routingConfiguration() != null) {
            routingConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("remoteVirtualNetwork", this.remoteVirtualNetwork);
        jsonWriter.writeBooleanField("allowHubToRemoteVnetTransit", this.allowHubToRemoteVnetTransit);
        jsonWriter.writeBooleanField("allowRemoteVnetToUseHubVnetGateways", this.allowRemoteVnetToUseHubVnetGateways);
        jsonWriter.writeBooleanField("enableInternetSecurity", this.enableInternetSecurity);
        jsonWriter.writeJsonField("routingConfiguration", this.routingConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HubVirtualNetworkConnectionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HubVirtualNetworkConnectionProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the HubVirtualNetworkConnectionProperties.
     */
    public static HubVirtualNetworkConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HubVirtualNetworkConnectionProperties deserializedHubVirtualNetworkConnectionProperties
                = new HubVirtualNetworkConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("remoteVirtualNetwork".equals(fieldName)) {
                    deserializedHubVirtualNetworkConnectionProperties.remoteVirtualNetwork
                        = SubResource.fromJson(reader);
                } else if ("allowHubToRemoteVnetTransit".equals(fieldName)) {
                    deserializedHubVirtualNetworkConnectionProperties.allowHubToRemoteVnetTransit
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowRemoteVnetToUseHubVnetGateways".equals(fieldName)) {
                    deserializedHubVirtualNetworkConnectionProperties.allowRemoteVnetToUseHubVnetGateways
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableInternetSecurity".equals(fieldName)) {
                    deserializedHubVirtualNetworkConnectionProperties.enableInternetSecurity
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("routingConfiguration".equals(fieldName)) {
                    deserializedHubVirtualNetworkConnectionProperties.routingConfiguration
                        = RoutingConfiguration.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedHubVirtualNetworkConnectionProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHubVirtualNetworkConnectionProperties;
        });
    }
}
