// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.HubRoute;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * RouteTable resource in a virtual hub.
 */
@Fluent
public final class HubRouteTableInner extends SubResource {
    /*
     * Properties of the RouteTable resource.
     */
    private HubRouteTableProperties innerProperties;

    /*
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * Resource type.
     */
    private String type;

    /**
     * Creates an instance of HubRouteTableInner class.
     */
    public HubRouteTableInner() {
    }

    /**
     * Get the innerProperties property: Properties of the RouteTable resource.
     * 
     * @return the innerProperties value.
     */
    private HubRouteTableProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @param name the name value to set.
     * @return the HubRouteTableInner object itself.
     */
    public HubRouteTableInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HubRouteTableInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the routes property: List of all routes.
     * 
     * @return the routes value.
     */
    public List<HubRoute> routes() {
        return this.innerProperties() == null ? null : this.innerProperties().routes();
    }

    /**
     * Set the routes property: List of all routes.
     * 
     * @param routes the routes value to set.
     * @return the HubRouteTableInner object itself.
     */
    public HubRouteTableInner withRoutes(List<HubRoute> routes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HubRouteTableProperties();
        }
        this.innerProperties().withRoutes(routes);
        return this;
    }

    /**
     * Get the labels property: List of labels associated with this route table.
     * 
     * @return the labels value.
     */
    public List<String> labels() {
        return this.innerProperties() == null ? null : this.innerProperties().labels();
    }

    /**
     * Set the labels property: List of labels associated with this route table.
     * 
     * @param labels the labels value to set.
     * @return the HubRouteTableInner object itself.
     */
    public HubRouteTableInner withLabels(List<String> labels) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HubRouteTableProperties();
        }
        this.innerProperties().withLabels(labels);
        return this;
    }

    /**
     * Get the associatedConnections property: List of all connections associated with this route table.
     * 
     * @return the associatedConnections value.
     */
    public List<String> associatedConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().associatedConnections();
    }

    /**
     * Get the propagatingConnections property: List of all connections that advertise to this route table.
     * 
     * @return the propagatingConnections value.
     */
    public List<String> propagatingConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().propagatingConnections();
    }

    /**
     * Get the provisioningState property: The provisioning state of the RouteTable resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HubRouteTableInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HubRouteTableInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HubRouteTableInner.
     */
    public static HubRouteTableInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HubRouteTableInner deserializedHubRouteTableInner = new HubRouteTableInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedHubRouteTableInner.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedHubRouteTableInner.innerProperties = HubRouteTableProperties.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedHubRouteTableInner.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedHubRouteTableInner.etag = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedHubRouteTableInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHubRouteTableInner;
        });
    }
}
