// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Hop link properties.
 */
@Immutable
public final class HopLinkProperties implements JsonSerializable<HopLinkProperties> {
    /*
     * Minimum roundtrip time in milliseconds.
     */
    private Long roundTripTimeMin;

    /*
     * Average roundtrip time in milliseconds.
     */
    private Long roundTripTimeAvg;

    /*
     * Maximum roundtrip time in milliseconds.
     */
    private Long roundTripTimeMax;

    /**
     * Creates an instance of HopLinkProperties class.
     */
    public HopLinkProperties() {
    }

    /**
     * Get the roundTripTimeMin property: Minimum roundtrip time in milliseconds.
     * 
     * @return the roundTripTimeMin value.
     */
    public Long roundTripTimeMin() {
        return this.roundTripTimeMin;
    }

    /**
     * Get the roundTripTimeAvg property: Average roundtrip time in milliseconds.
     * 
     * @return the roundTripTimeAvg value.
     */
    public Long roundTripTimeAvg() {
        return this.roundTripTimeAvg;
    }

    /**
     * Get the roundTripTimeMax property: Maximum roundtrip time in milliseconds.
     * 
     * @return the roundTripTimeMax value.
     */
    public Long roundTripTimeMax() {
        return this.roundTripTimeMax;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HopLinkProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HopLinkProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HopLinkProperties.
     */
    public static HopLinkProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HopLinkProperties deserializedHopLinkProperties = new HopLinkProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("roundTripTimeMin".equals(fieldName)) {
                    deserializedHopLinkProperties.roundTripTimeMin = reader.getNullable(JsonReader::getLong);
                } else if ("roundTripTimeAvg".equals(fieldName)) {
                    deserializedHopLinkProperties.roundTripTimeAvg = reader.getNullable(JsonReader::getLong);
                } else if ("roundTripTimeMax".equals(fieldName)) {
                    deserializedHopLinkProperties.roundTripTimeMax = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHopLinkProperties;
        });
    }
}
