// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ExpressRouteServiceProviderBandwidthsOffered;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Properties of ExpressRouteServiceProvider.
 */
@Fluent
public final class ExpressRouteServiceProviderPropertiesFormat
    implements JsonSerializable<ExpressRouteServiceProviderPropertiesFormat> {
    /*
     * A list of peering locations.
     */
    private List<String> peeringLocations;

    /*
     * A list of bandwidths offered.
     */
    private List<ExpressRouteServiceProviderBandwidthsOffered> bandwidthsOffered;

    /*
     * The provisioning state of the express route service provider resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ExpressRouteServiceProviderPropertiesFormat class.
     */
    public ExpressRouteServiceProviderPropertiesFormat() {
    }

    /**
     * Get the peeringLocations property: A list of peering locations.
     * 
     * @return the peeringLocations value.
     */
    public List<String> peeringLocations() {
        return this.peeringLocations;
    }

    /**
     * Set the peeringLocations property: A list of peering locations.
     * 
     * @param peeringLocations the peeringLocations value to set.
     * @return the ExpressRouteServiceProviderPropertiesFormat object itself.
     */
    public ExpressRouteServiceProviderPropertiesFormat withPeeringLocations(List<String> peeringLocations) {
        this.peeringLocations = peeringLocations;
        return this;
    }

    /**
     * Get the bandwidthsOffered property: A list of bandwidths offered.
     * 
     * @return the bandwidthsOffered value.
     */
    public List<ExpressRouteServiceProviderBandwidthsOffered> bandwidthsOffered() {
        return this.bandwidthsOffered;
    }

    /**
     * Set the bandwidthsOffered property: A list of bandwidths offered.
     * 
     * @param bandwidthsOffered the bandwidthsOffered value to set.
     * @return the ExpressRouteServiceProviderPropertiesFormat object itself.
     */
    public ExpressRouteServiceProviderPropertiesFormat
        withBandwidthsOffered(List<ExpressRouteServiceProviderBandwidthsOffered> bandwidthsOffered) {
        this.bandwidthsOffered = bandwidthsOffered;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the express route service provider resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (bandwidthsOffered() != null) {
            bandwidthsOffered().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("peeringLocations", this.peeringLocations,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("bandwidthsOffered", this.bandwidthsOffered,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteServiceProviderPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteServiceProviderPropertiesFormat if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteServiceProviderPropertiesFormat.
     */
    public static ExpressRouteServiceProviderPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteServiceProviderPropertiesFormat deserializedExpressRouteServiceProviderPropertiesFormat
                = new ExpressRouteServiceProviderPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("peeringLocations".equals(fieldName)) {
                    List<String> peeringLocations = reader.readArray(reader1 -> reader1.getString());
                    deserializedExpressRouteServiceProviderPropertiesFormat.peeringLocations = peeringLocations;
                } else if ("bandwidthsOffered".equals(fieldName)) {
                    List<ExpressRouteServiceProviderBandwidthsOffered> bandwidthsOffered
                        = reader.readArray(reader1 -> ExpressRouteServiceProviderBandwidthsOffered.fromJson(reader1));
                    deserializedExpressRouteServiceProviderPropertiesFormat.bandwidthsOffered = bandwidthsOffered;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedExpressRouteServiceProviderPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteServiceProviderPropertiesFormat;
        });
    }
}
