// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.EffectiveRoute;
import java.io.IOException;
import java.util.List;

/**
 * Response for list effective route API service call.
 */
@Fluent
public final class EffectiveRouteListResultInner implements JsonSerializable<EffectiveRouteListResultInner> {
    /*
     * A list of effective routes.
     */
    private List<EffectiveRoute> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of EffectiveRouteListResultInner class.
     */
    public EffectiveRouteListResultInner() {
    }

    /**
     * Get the value property: A list of effective routes.
     * 
     * @return the value value.
     */
    public List<EffectiveRoute> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of effective routes.
     * 
     * @param value the value value to set.
     * @return the EffectiveRouteListResultInner object itself.
     */
    public EffectiveRouteListResultInner withValue(List<EffectiveRoute> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EffectiveRouteListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EffectiveRouteListResultInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EffectiveRouteListResultInner.
     */
    public static EffectiveRouteListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EffectiveRouteListResultInner deserializedEffectiveRouteListResultInner
                = new EffectiveRouteListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<EffectiveRoute> value = reader.readArray(reader1 -> EffectiveRoute.fromJson(reader1));
                    deserializedEffectiveRouteListResultInner.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedEffectiveRouteListResultInner.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEffectiveRouteListResultInner;
        });
    }
}
