// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * A DDoS protection plan in a resource group.
 */
@Fluent
public final class DdosProtectionPlanInner extends Resource {
    /*
     * Properties of the DDoS protection plan.
     */
    private DdosProtectionPlanPropertiesFormat innerProperties;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DdosProtectionPlanInner class.
     */
    public DdosProtectionPlanInner() {
    }

    /**
     * Get the innerProperties property: Properties of the DDoS protection plan.
     * 
     * @return the innerProperties value.
     */
    private DdosProtectionPlanPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DdosProtectionPlanInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DdosProtectionPlanInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the resourceGuid property: The resource GUID property of the DDoS protection plan resource. It uniquely
     * identifies the resource, even if the user changes its name or migrate the resource across subscriptions or
     * resource groups.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    /**
     * Get the provisioningState property: The provisioning state of the DDoS protection plan resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the publicIpAddresses property: The list of public IPs associated with the DDoS protection plan resource.
     * This list is read-only.
     * 
     * @return the publicIpAddresses value.
     */
    public List<SubResource> publicIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddresses();
    }

    /**
     * Get the virtualNetworks property: The list of virtual networks associated with the DDoS protection plan resource.
     * This list is read-only.
     * 
     * @return the virtualNetworks value.
     */
    public List<SubResource> virtualNetworks() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworks();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DdosProtectionPlanInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DdosProtectionPlanInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DdosProtectionPlanInner.
     */
    public static DdosProtectionPlanInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DdosProtectionPlanInner deserializedDdosProtectionPlanInner = new DdosProtectionPlanInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDdosProtectionPlanInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDdosProtectionPlanInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDdosProtectionPlanInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedDdosProtectionPlanInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDdosProtectionPlanInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedDdosProtectionPlanInner.innerProperties
                        = DdosProtectionPlanPropertiesFormat.fromJson(reader);
                } else if ("etag".equals(fieldName)) {
                    deserializedDdosProtectionPlanInner.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDdosProtectionPlanInner;
        });
    }
}
