// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.HubBgpConnectionStatus;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Properties of the bgp connection.
 */
@Fluent
public final class BgpConnectionProperties implements JsonSerializable<BgpConnectionProperties> {
    /*
     * Peer ASN.
     */
    private Long peerAsn;

    /*
     * Peer IP.
     */
    private String peerIp;

    /*
     * The reference to the HubVirtualNetworkConnection resource.
     */
    private SubResource hubVirtualNetworkConnection;

    /*
     * The provisioning state of the resource.
     */
    private ProvisioningState provisioningState;

    /*
     * The current state of the VirtualHub to Peer.
     */
    private HubBgpConnectionStatus connectionState;

    /**
     * Creates an instance of BgpConnectionProperties class.
     */
    public BgpConnectionProperties() {
    }

    /**
     * Get the peerAsn property: Peer ASN.
     * 
     * @return the peerAsn value.
     */
    public Long peerAsn() {
        return this.peerAsn;
    }

    /**
     * Set the peerAsn property: Peer ASN.
     * 
     * @param peerAsn the peerAsn value to set.
     * @return the BgpConnectionProperties object itself.
     */
    public BgpConnectionProperties withPeerAsn(Long peerAsn) {
        this.peerAsn = peerAsn;
        return this;
    }

    /**
     * Get the peerIp property: Peer IP.
     * 
     * @return the peerIp value.
     */
    public String peerIp() {
        return this.peerIp;
    }

    /**
     * Set the peerIp property: Peer IP.
     * 
     * @param peerIp the peerIp value to set.
     * @return the BgpConnectionProperties object itself.
     */
    public BgpConnectionProperties withPeerIp(String peerIp) {
        this.peerIp = peerIp;
        return this;
    }

    /**
     * Get the hubVirtualNetworkConnection property: The reference to the HubVirtualNetworkConnection resource.
     * 
     * @return the hubVirtualNetworkConnection value.
     */
    public SubResource hubVirtualNetworkConnection() {
        return this.hubVirtualNetworkConnection;
    }

    /**
     * Set the hubVirtualNetworkConnection property: The reference to the HubVirtualNetworkConnection resource.
     * 
     * @param hubVirtualNetworkConnection the hubVirtualNetworkConnection value to set.
     * @return the BgpConnectionProperties object itself.
     */
    public BgpConnectionProperties withHubVirtualNetworkConnection(SubResource hubVirtualNetworkConnection) {
        this.hubVirtualNetworkConnection = hubVirtualNetworkConnection;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the connectionState property: The current state of the VirtualHub to Peer.
     * 
     * @return the connectionState value.
     */
    public HubBgpConnectionStatus connectionState() {
        return this.connectionState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("peerAsn", this.peerAsn);
        jsonWriter.writeStringField("peerIp", this.peerIp);
        jsonWriter.writeJsonField("hubVirtualNetworkConnection", this.hubVirtualNetworkConnection);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BgpConnectionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BgpConnectionProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BgpConnectionProperties.
     */
    public static BgpConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BgpConnectionProperties deserializedBgpConnectionProperties = new BgpConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("peerAsn".equals(fieldName)) {
                    deserializedBgpConnectionProperties.peerAsn = reader.getNullable(JsonReader::getLong);
                } else if ("peerIp".equals(fieldName)) {
                    deserializedBgpConnectionProperties.peerIp = reader.getString();
                } else if ("hubVirtualNetworkConnection".equals(fieldName)) {
                    deserializedBgpConnectionProperties.hubVirtualNetworkConnection = SubResource.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedBgpConnectionProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("connectionState".equals(fieldName)) {
                    deserializedBgpConnectionProperties.connectionState
                        = HubBgpConnectionStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBgpConnectionProperties;
        });
    }
}
