// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The session state detail for a target.
 */
@Immutable
public final class BastionSessionStateInner implements JsonSerializable<BastionSessionStateInner> {
    /*
     * A unique id for the session.
     */
    private String sessionId;

    /*
     * Used for extra information.
     */
    private String message;

    /*
     * The state of the session. Disconnected/Failed/NotFound.
     */
    private String state;

    /**
     * Creates an instance of BastionSessionStateInner class.
     */
    public BastionSessionStateInner() {
    }

    /**
     * Get the sessionId property: A unique id for the session.
     * 
     * @return the sessionId value.
     */
    public String sessionId() {
        return this.sessionId;
    }

    /**
     * Get the message property: Used for extra information.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Get the state property: The state of the session. Disconnected/Failed/NotFound.
     * 
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BastionSessionStateInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BastionSessionStateInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BastionSessionStateInner.
     */
    public static BastionSessionStateInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BastionSessionStateInner deserializedBastionSessionStateInner = new BastionSessionStateInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sessionId".equals(fieldName)) {
                    deserializedBastionSessionStateInner.sessionId = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedBastionSessionStateInner.message = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedBastionSessionStateInner.state = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBastionSessionStateInner;
        });
    }
}
