// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayLoadDistributionAlgorithm;
import com.azure.resourcemanager.network.models.ApplicationGatewayLoadDistributionTarget;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Properties of Load Distribution Policy of an application gateway.
 */
@Fluent
public final class ApplicationGatewayLoadDistributionPolicyPropertiesFormat
    implements JsonSerializable<ApplicationGatewayLoadDistributionPolicyPropertiesFormat> {
    /*
     * Load Distribution Targets resource of an application gateway.
     */
    private List<ApplicationGatewayLoadDistributionTarget> loadDistributionTargets;

    /*
     * Load Distribution Targets resource of an application gateway.
     */
    private ApplicationGatewayLoadDistributionAlgorithm loadDistributionAlgorithm;

    /*
     * The provisioning state of the Load Distribution Policy resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ApplicationGatewayLoadDistributionPolicyPropertiesFormat class.
     */
    public ApplicationGatewayLoadDistributionPolicyPropertiesFormat() {
    }

    /**
     * Get the loadDistributionTargets property: Load Distribution Targets resource of an application gateway.
     * 
     * @return the loadDistributionTargets value.
     */
    public List<ApplicationGatewayLoadDistributionTarget> loadDistributionTargets() {
        return this.loadDistributionTargets;
    }

    /**
     * Set the loadDistributionTargets property: Load Distribution Targets resource of an application gateway.
     * 
     * @param loadDistributionTargets the loadDistributionTargets value to set.
     * @return the ApplicationGatewayLoadDistributionPolicyPropertiesFormat object itself.
     */
    public ApplicationGatewayLoadDistributionPolicyPropertiesFormat
        withLoadDistributionTargets(List<ApplicationGatewayLoadDistributionTarget> loadDistributionTargets) {
        this.loadDistributionTargets = loadDistributionTargets;
        return this;
    }

    /**
     * Get the loadDistributionAlgorithm property: Load Distribution Targets resource of an application gateway.
     * 
     * @return the loadDistributionAlgorithm value.
     */
    public ApplicationGatewayLoadDistributionAlgorithm loadDistributionAlgorithm() {
        return this.loadDistributionAlgorithm;
    }

    /**
     * Set the loadDistributionAlgorithm property: Load Distribution Targets resource of an application gateway.
     * 
     * @param loadDistributionAlgorithm the loadDistributionAlgorithm value to set.
     * @return the ApplicationGatewayLoadDistributionPolicyPropertiesFormat object itself.
     */
    public ApplicationGatewayLoadDistributionPolicyPropertiesFormat
        withLoadDistributionAlgorithm(ApplicationGatewayLoadDistributionAlgorithm loadDistributionAlgorithm) {
        this.loadDistributionAlgorithm = loadDistributionAlgorithm;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the Load Distribution Policy resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (loadDistributionTargets() != null) {
            loadDistributionTargets().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("loadDistributionTargets", this.loadDistributionTargets,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("loadDistributionAlgorithm",
            this.loadDistributionAlgorithm == null ? null : this.loadDistributionAlgorithm.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayLoadDistributionPolicyPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayLoadDistributionPolicyPropertiesFormat if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * ApplicationGatewayLoadDistributionPolicyPropertiesFormat.
     */
    public static ApplicationGatewayLoadDistributionPolicyPropertiesFormat fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayLoadDistributionPolicyPropertiesFormat deserializedApplicationGatewayLoadDistributionPolicyPropertiesFormat
                = new ApplicationGatewayLoadDistributionPolicyPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("loadDistributionTargets".equals(fieldName)) {
                    List<ApplicationGatewayLoadDistributionTarget> loadDistributionTargets
                        = reader.readArray(reader1 -> ApplicationGatewayLoadDistributionTarget.fromJson(reader1));
                    deserializedApplicationGatewayLoadDistributionPolicyPropertiesFormat.loadDistributionTargets
                        = loadDistributionTargets;
                } else if ("loadDistributionAlgorithm".equals(fieldName)) {
                    deserializedApplicationGatewayLoadDistributionPolicyPropertiesFormat.loadDistributionAlgorithm
                        = ApplicationGatewayLoadDistributionAlgorithm.fromString(reader.getString());
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayLoadDistributionPolicyPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayLoadDistributionPolicyPropertiesFormat;
        });
    }
}
