/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.NetworkManagerCommitsClient;
import com.azure.resourcemanager.network.fluent.models.NetworkManagerCommitInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class NetworkManagerCommitsClientImpl
implements NetworkManagerCommitsClient {
    private final NetworkManagerCommitsService service;
    private final NetworkManagementClientImpl client;

    NetworkManagerCommitsClientImpl(NetworkManagementClientImpl client) {
        this.service = (NetworkManagerCommitsService)RestProxy.create(NetworkManagerCommitsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> postWithResponseAsync(String resourceGroupName, String networkManagerName, NetworkManagerCommitInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2023-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.post(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, "2023-06-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> postWithResponseAsync(String resourceGroupName, String networkManagerName, NetworkManagerCommitInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2023-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.post(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, "2023-06-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<NetworkManagerCommitInner>, NetworkManagerCommitInner> beginPostAsync(String resourceGroupName, String networkManagerName, NetworkManagerCommitInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.postWithResponseAsync(resourceGroupName, networkManagerName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)NetworkManagerCommitInner.class), (Type)((Object)NetworkManagerCommitInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<NetworkManagerCommitInner>, NetworkManagerCommitInner> beginPostAsync(String resourceGroupName, String networkManagerName, NetworkManagerCommitInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.postWithResponseAsync(resourceGroupName, networkManagerName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)NetworkManagerCommitInner.class), (Type)((Object)NetworkManagerCommitInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NetworkManagerCommitInner>, NetworkManagerCommitInner> beginPost(String resourceGroupName, String networkManagerName, NetworkManagerCommitInner parameters) {
        return this.beginPostAsync(resourceGroupName, networkManagerName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<NetworkManagerCommitInner>, NetworkManagerCommitInner> beginPost(String resourceGroupName, String networkManagerName, NetworkManagerCommitInner parameters, Context context) {
        return this.beginPostAsync(resourceGroupName, networkManagerName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NetworkManagerCommitInner> postAsync(String resourceGroupName, String networkManagerName, NetworkManagerCommitInner parameters) {
        return this.beginPostAsync(resourceGroupName, networkManagerName, parameters).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NetworkManagerCommitInner> postAsync(String resourceGroupName, String networkManagerName, NetworkManagerCommitInner parameters, Context context) {
        return this.beginPostAsync(resourceGroupName, networkManagerName, parameters, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkManagerCommitInner post(String resourceGroupName, String networkManagerName, NetworkManagerCommitInner parameters) {
        return (NetworkManagerCommitInner)this.postAsync(resourceGroupName, networkManagerName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkManagerCommitInner post(String resourceGroupName, String networkManagerName, NetworkManagerCommitInner parameters, Context context) {
        return (NetworkManagerCommitInner)this.postAsync(resourceGroupName, networkManagerName, parameters, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    public static interface NetworkManagerCommitsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/commit")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> post(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkManagerName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") NetworkManagerCommitInner var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

