/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ApplicationSecurityGroupInner;
import com.azure.resourcemanager.network.fluent.models.SecurityRuleInner;
import com.azure.resourcemanager.network.implementation.NetworkSecurityGroupImpl;
import com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.azure.resourcemanager.network.models.NetworkSecurityRule;
import com.azure.resourcemanager.network.models.SecurityRuleAccess;
import com.azure.resourcemanager.network.models.SecurityRuleDirection;
import com.azure.resourcemanager.network.models.SecurityRuleProtocol;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class NetworkSecurityRuleImpl
extends ChildResourceImpl<SecurityRuleInner, NetworkSecurityGroupImpl, NetworkSecurityGroup>
implements NetworkSecurityRule,
NetworkSecurityRule.Definition<NetworkSecurityGroup.DefinitionStages.WithCreate>,
NetworkSecurityRule.UpdateDefinition<NetworkSecurityGroup.Update>,
NetworkSecurityRule.Update {
    private Map<String, ApplicationSecurityGroupInner> sourceAsgs = new HashMap<String, ApplicationSecurityGroupInner>();
    private Map<String, ApplicationSecurityGroupInner> destinationAsgs = new HashMap<String, ApplicationSecurityGroupInner>();
    private final ClientLogger logger = new ClientLogger(this.getClass());

    NetworkSecurityRuleImpl(SecurityRuleInner inner, NetworkSecurityGroupImpl parent) {
        super((Object)inner, (Object)parent);
        if (inner.sourceApplicationSecurityGroups() != null) {
            for (ApplicationSecurityGroupInner asg : inner.sourceApplicationSecurityGroups()) {
                this.sourceAsgs.put(asg.id(), asg);
            }
        }
        if (inner.destinationApplicationSecurityGroups() != null) {
            for (ApplicationSecurityGroupInner asg : inner.destinationApplicationSecurityGroups()) {
                this.destinationAsgs.put(asg.id(), asg);
            }
        }
    }

    public String name() {
        return ((SecurityRuleInner)((Object)this.innerModel())).name();
    }

    @Override
    public SecurityRuleDirection direction() {
        return ((SecurityRuleInner)((Object)this.innerModel())).direction();
    }

    @Override
    public SecurityRuleProtocol protocol() {
        return ((SecurityRuleInner)((Object)this.innerModel())).protocol();
    }

    @Override
    public SecurityRuleAccess access() {
        return ((SecurityRuleInner)((Object)this.innerModel())).access();
    }

    @Override
    public String sourceAddressPrefix() {
        return ((SecurityRuleInner)((Object)this.innerModel())).sourceAddressPrefix();
    }

    @Override
    public List<String> sourceAddressPrefixes() {
        return Collections.unmodifiableList(((SecurityRuleInner)((Object)this.innerModel())).sourceAddressPrefixes());
    }

    @Override
    public String sourcePortRange() {
        return ((SecurityRuleInner)((Object)this.innerModel())).sourcePortRange();
    }

    @Override
    public List<String> sourcePortRanges() {
        return Collections.unmodifiableList(((SecurityRuleInner)((Object)this.innerModel())).sourcePortRanges());
    }

    @Override
    public String destinationAddressPrefix() {
        return ((SecurityRuleInner)((Object)this.innerModel())).destinationAddressPrefix();
    }

    @Override
    public List<String> destinationAddressPrefixes() {
        return Collections.unmodifiableList(((SecurityRuleInner)((Object)this.innerModel())).destinationAddressPrefixes());
    }

    @Override
    public String destinationPortRange() {
        return ((SecurityRuleInner)((Object)this.innerModel())).destinationPortRange();
    }

    @Override
    public List<String> destinationPortRanges() {
        return Collections.unmodifiableList(((SecurityRuleInner)((Object)this.innerModel())).destinationPortRanges());
    }

    @Override
    public int priority() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((SecurityRuleInner)((Object)this.innerModel())).priority());
    }

    @Override
    public Set<String> sourceApplicationSecurityGroupIds() {
        return Collections.unmodifiableSet(this.sourceAsgs.keySet());
    }

    @Override
    public Set<String> destinationApplicationSecurityGroupIds() {
        return Collections.unmodifiableSet(this.destinationAsgs.keySet());
    }

    @Override
    public NetworkSecurityRuleImpl allowInbound() {
        return this.withDirection(SecurityRuleDirection.INBOUND).withAccess(SecurityRuleAccess.ALLOW);
    }

    @Override
    public NetworkSecurityRuleImpl allowOutbound() {
        return this.withDirection(SecurityRuleDirection.OUTBOUND).withAccess(SecurityRuleAccess.ALLOW);
    }

    @Override
    public NetworkSecurityRuleImpl denyInbound() {
        return this.withDirection(SecurityRuleDirection.INBOUND).withAccess(SecurityRuleAccess.DENY);
    }

    @Override
    public NetworkSecurityRuleImpl denyOutbound() {
        return this.withDirection(SecurityRuleDirection.OUTBOUND).withAccess(SecurityRuleAccess.DENY);
    }

    @Override
    public NetworkSecurityRuleImpl withProtocol(SecurityRuleProtocol protocol) {
        ((SecurityRuleInner)((Object)this.innerModel())).withProtocol(protocol);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withAnyProtocol() {
        return this.withProtocol(SecurityRuleProtocol.ASTERISK);
    }

    @Override
    public NetworkSecurityRuleImpl fromAddress(String cidr) {
        ((SecurityRuleInner)((Object)this.innerModel())).withSourceAddressPrefix(cidr);
        ((SecurityRuleInner)((Object)this.innerModel())).withSourceAddressPrefixes(null);
        ((SecurityRuleInner)((Object)this.innerModel())).withSourceApplicationSecurityGroups(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromAnyAddress() {
        ((SecurityRuleInner)((Object)this.innerModel())).withSourceAddressPrefix("*");
        ((SecurityRuleInner)((Object)this.innerModel())).withSourceAddressPrefixes(null);
        ((SecurityRuleInner)((Object)this.innerModel())).withSourceApplicationSecurityGroups(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromAddresses(String ... addresses) {
        ((SecurityRuleInner)((Object)this.innerModel())).withSourceAddressPrefixes(Arrays.asList(addresses));
        ((SecurityRuleInner)((Object)this.innerModel())).withSourceAddressPrefix(null);
        ((SecurityRuleInner)((Object)this.innerModel())).withSourceApplicationSecurityGroups(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromPort(int port) {
        ((SecurityRuleInner)((Object)this.innerModel())).withSourcePortRange(String.valueOf(port));
        ((SecurityRuleInner)((Object)this.innerModel())).withSourcePortRanges(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromAnyPort() {
        ((SecurityRuleInner)((Object)this.innerModel())).withSourcePortRange("*");
        ((SecurityRuleInner)((Object)this.innerModel())).withSourcePortRanges(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromPortRange(int from, int to) {
        ((SecurityRuleInner)((Object)this.innerModel())).withSourcePortRange(String.valueOf(from) + "-" + String.valueOf(to));
        ((SecurityRuleInner)((Object)this.innerModel())).withSourcePortRanges(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl fromPortRanges(String ... ranges) {
        ((SecurityRuleInner)((Object)this.innerModel())).withSourcePortRanges(Arrays.asList(ranges));
        ((SecurityRuleInner)((Object)this.innerModel())).withSourcePortRange(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toAddress(String cidr) {
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationAddressPrefix(cidr);
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationAddressPrefixes(null);
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationApplicationSecurityGroups(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toAddresses(String ... addresses) {
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationAddressPrefixes(Arrays.asList(addresses));
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationAddressPrefix(null);
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationApplicationSecurityGroups(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toAnyAddress() {
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationAddressPrefix("*");
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationAddressPrefixes(null);
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationApplicationSecurityGroups(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toPort(int port) {
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationPortRange(String.valueOf(port));
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationPortRanges(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toAnyPort() {
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationPortRange("*");
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationPortRanges(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toPortRange(int from, int to) {
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationPortRange(String.valueOf(from) + "-" + String.valueOf(to));
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationPortRanges(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl toPortRanges(String ... ranges) {
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationPortRanges(Arrays.asList(ranges));
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationPortRange(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withPriority(int priority) {
        if (priority < 100 || priority > 4096) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The priority number of a network security rule must be between 100 and 4096."));
        }
        ((SecurityRuleInner)((Object)this.innerModel())).withPriority(priority);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withDescription(String description) {
        ((SecurityRuleInner)((Object)this.innerModel())).withDescription(description);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withSourceApplicationSecurityGroup(String id) {
        this.sourceAsgs.put(id, new ApplicationSecurityGroupInner().withId(id));
        ((SecurityRuleInner)((Object)this.innerModel())).withSourceAddressPrefix(null);
        ((SecurityRuleInner)((Object)this.innerModel())).withSourceAddressPrefixes(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withoutSourceApplicationSecurityGroup(String id) {
        this.sourceAsgs.remove(id);
        return this;
    }

    public NetworkSecurityRuleImpl withSourceApplicationSecurityGroup(String ... ids) {
        this.sourceAsgs = Arrays.stream(ids).collect(Collectors.toMap(Function.identity(), id -> new ApplicationSecurityGroupInner().withId((String)id)));
        ((SecurityRuleInner)((Object)this.innerModel())).withSourceAddressPrefix(null);
        ((SecurityRuleInner)((Object)this.innerModel())).withSourceAddressPrefixes(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withDestinationApplicationSecurityGroup(String id) {
        this.destinationAsgs.put(id, new ApplicationSecurityGroupInner().withId(id));
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationAddressPrefix(null);
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationAddressPrefixes(null);
        return this;
    }

    @Override
    public NetworkSecurityRuleImpl withoutDestinationApplicationSecurityGroup(String id) {
        this.destinationAsgs.remove(id);
        return this;
    }

    public NetworkSecurityRuleImpl withDestinationApplicationSecurityGroup(String ... ids) {
        this.destinationAsgs = Arrays.stream(ids).collect(Collectors.toMap(Function.identity(), id -> new ApplicationSecurityGroupInner().withId((String)id)));
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationAddressPrefix(null);
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationAddressPrefixes(null);
        return this;
    }

    private NetworkSecurityRuleImpl withDirection(SecurityRuleDirection direction) {
        ((SecurityRuleInner)((Object)this.innerModel())).withDirection(direction);
        return this;
    }

    private NetworkSecurityRuleImpl withAccess(SecurityRuleAccess permission) {
        ((SecurityRuleInner)((Object)this.innerModel())).withAccess(permission);
        return this;
    }

    public NetworkSecurityGroupImpl attach() {
        return this.parent().withRule(this);
    }

    public NetworkSecurityGroupImpl parent() {
        ((SecurityRuleInner)((Object)this.innerModel())).withSourceApplicationSecurityGroups(new ArrayList<ApplicationSecurityGroupInner>(this.sourceAsgs.values()));
        ((SecurityRuleInner)((Object)this.innerModel())).withDestinationApplicationSecurityGroups(new ArrayList<ApplicationSecurityGroupInner>(this.destinationAsgs.values()));
        return (NetworkSecurityGroupImpl)super.parent();
    }

    @Override
    public String description() {
        return ((SecurityRuleInner)((Object)this.innerModel())).description();
    }
}

