/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.LocalNetworkGatewayInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayInner;
import com.azure.resourcemanager.network.models.IpsecPolicy;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.TrafficSelectorPolicy;
import com.azure.resourcemanager.network.models.TunnelConnectionHealth;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionMode;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionProtocol;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionStatus;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class VirtualNetworkGatewayConnectionPropertiesFormatInner {
    @JsonProperty(value="authorizationKey")
    private String authorizationKey;
    @JsonProperty(value="virtualNetworkGateway1", required=true)
    private VirtualNetworkGatewayInner virtualNetworkGateway1;
    @JsonProperty(value="virtualNetworkGateway2")
    private VirtualNetworkGatewayInner virtualNetworkGateway2;
    @JsonProperty(value="localNetworkGateway2")
    private LocalNetworkGatewayInner localNetworkGateway2;
    @JsonProperty(value="ingressNatRules")
    private List<SubResource> ingressNatRules;
    @JsonProperty(value="egressNatRules")
    private List<SubResource> egressNatRules;
    @JsonProperty(value="connectionType", required=true)
    private VirtualNetworkGatewayConnectionType connectionType;
    @JsonProperty(value="connectionProtocol")
    private VirtualNetworkGatewayConnectionProtocol connectionProtocol;
    @JsonProperty(value="routingWeight")
    private Integer routingWeight;
    @JsonProperty(value="dpdTimeoutSeconds")
    private Integer dpdTimeoutSeconds;
    @JsonProperty(value="connectionMode")
    private VirtualNetworkGatewayConnectionMode connectionMode;
    @JsonProperty(value="sharedKey")
    private String sharedKey;
    @JsonProperty(value="connectionStatus", access=JsonProperty.Access.WRITE_ONLY)
    private VirtualNetworkGatewayConnectionStatus connectionStatus;
    @JsonProperty(value="tunnelConnectionStatus", access=JsonProperty.Access.WRITE_ONLY)
    private List<TunnelConnectionHealth> tunnelConnectionStatus;
    @JsonProperty(value="egressBytesTransferred", access=JsonProperty.Access.WRITE_ONLY)
    private Long egressBytesTransferred;
    @JsonProperty(value="ingressBytesTransferred", access=JsonProperty.Access.WRITE_ONLY)
    private Long ingressBytesTransferred;
    @JsonProperty(value="peer")
    private SubResource peer;
    @JsonProperty(value="enableBgp")
    private Boolean enableBgp;
    @JsonProperty(value="useLocalAzureIpAddress")
    private Boolean useLocalAzureIpAddress;
    @JsonProperty(value="usePolicyBasedTrafficSelectors")
    private Boolean usePolicyBasedTrafficSelectors;
    @JsonProperty(value="ipsecPolicies")
    private List<IpsecPolicy> ipsecPolicies;
    @JsonProperty(value="trafficSelectorPolicies")
    private List<TrafficSelectorPolicy> trafficSelectorPolicies;
    @JsonProperty(value="resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="expressRouteGatewayBypass")
    private Boolean expressRouteGatewayBypass;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkGatewayConnectionPropertiesFormatInner.class);

    public String authorizationKey() {
        return this.authorizationKey;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withAuthorizationKey(String authorizationKey) {
        this.authorizationKey = authorizationKey;
        return this;
    }

    public VirtualNetworkGatewayInner virtualNetworkGateway1() {
        return this.virtualNetworkGateway1;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withVirtualNetworkGateway1(VirtualNetworkGatewayInner virtualNetworkGateway1) {
        this.virtualNetworkGateway1 = virtualNetworkGateway1;
        return this;
    }

    public VirtualNetworkGatewayInner virtualNetworkGateway2() {
        return this.virtualNetworkGateway2;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withVirtualNetworkGateway2(VirtualNetworkGatewayInner virtualNetworkGateway2) {
        this.virtualNetworkGateway2 = virtualNetworkGateway2;
        return this;
    }

    public LocalNetworkGatewayInner localNetworkGateway2() {
        return this.localNetworkGateway2;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withLocalNetworkGateway2(LocalNetworkGatewayInner localNetworkGateway2) {
        this.localNetworkGateway2 = localNetworkGateway2;
        return this;
    }

    public List<SubResource> ingressNatRules() {
        return this.ingressNatRules;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withIngressNatRules(List<SubResource> ingressNatRules) {
        this.ingressNatRules = ingressNatRules;
        return this;
    }

    public List<SubResource> egressNatRules() {
        return this.egressNatRules;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withEgressNatRules(List<SubResource> egressNatRules) {
        this.egressNatRules = egressNatRules;
        return this;
    }

    public VirtualNetworkGatewayConnectionType connectionType() {
        return this.connectionType;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withConnectionType(VirtualNetworkGatewayConnectionType connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    public VirtualNetworkGatewayConnectionProtocol connectionProtocol() {
        return this.connectionProtocol;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withConnectionProtocol(VirtualNetworkGatewayConnectionProtocol connectionProtocol) {
        this.connectionProtocol = connectionProtocol;
        return this;
    }

    public Integer routingWeight() {
        return this.routingWeight;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withRoutingWeight(Integer routingWeight) {
        this.routingWeight = routingWeight;
        return this;
    }

    public Integer dpdTimeoutSeconds() {
        return this.dpdTimeoutSeconds;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withDpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
        this.dpdTimeoutSeconds = dpdTimeoutSeconds;
        return this;
    }

    public VirtualNetworkGatewayConnectionMode connectionMode() {
        return this.connectionMode;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withConnectionMode(VirtualNetworkGatewayConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
        return this;
    }

    public String sharedKey() {
        return this.sharedKey;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
        return this;
    }

    public VirtualNetworkGatewayConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    public List<TunnelConnectionHealth> tunnelConnectionStatus() {
        return this.tunnelConnectionStatus;
    }

    public Long egressBytesTransferred() {
        return this.egressBytesTransferred;
    }

    public Long ingressBytesTransferred() {
        return this.ingressBytesTransferred;
    }

    public SubResource peer() {
        return this.peer;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withPeer(SubResource peer) {
        this.peer = peer;
        return this;
    }

    public Boolean enableBgp() {
        return this.enableBgp;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withEnableBgp(Boolean enableBgp) {
        this.enableBgp = enableBgp;
        return this;
    }

    public Boolean useLocalAzureIpAddress() {
        return this.useLocalAzureIpAddress;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withUseLocalAzureIpAddress(Boolean useLocalAzureIpAddress) {
        this.useLocalAzureIpAddress = useLocalAzureIpAddress;
        return this;
    }

    public Boolean usePolicyBasedTrafficSelectors() {
        return this.usePolicyBasedTrafficSelectors;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withUsePolicyBasedTrafficSelectors(Boolean usePolicyBasedTrafficSelectors) {
        this.usePolicyBasedTrafficSelectors = usePolicyBasedTrafficSelectors;
        return this;
    }

    public List<IpsecPolicy> ipsecPolicies() {
        return this.ipsecPolicies;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withIpsecPolicies(List<IpsecPolicy> ipsecPolicies) {
        this.ipsecPolicies = ipsecPolicies;
        return this;
    }

    public List<TrafficSelectorPolicy> trafficSelectorPolicies() {
        return this.trafficSelectorPolicies;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withTrafficSelectorPolicies(List<TrafficSelectorPolicy> trafficSelectorPolicies) {
        this.trafficSelectorPolicies = trafficSelectorPolicies;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean expressRouteGatewayBypass() {
        return this.expressRouteGatewayBypass;
    }

    public VirtualNetworkGatewayConnectionPropertiesFormatInner withExpressRouteGatewayBypass(Boolean expressRouteGatewayBypass) {
        this.expressRouteGatewayBypass = expressRouteGatewayBypass;
        return this;
    }

    public void validate() {
        if (this.virtualNetworkGateway1() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property virtualNetworkGateway1 in model VirtualNetworkGatewayConnectionPropertiesFormatInner"));
        }
        this.virtualNetworkGateway1().validate();
        if (this.virtualNetworkGateway2() != null) {
            this.virtualNetworkGateway2().validate();
        }
        if (this.localNetworkGateway2() != null) {
            this.localNetworkGateway2().validate();
        }
        if (this.connectionType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property connectionType in model VirtualNetworkGatewayConnectionPropertiesFormatInner"));
        }
        if (this.tunnelConnectionStatus() != null) {
            this.tunnelConnectionStatus().forEach(e -> e.validate());
        }
        if (this.ipsecPolicies() != null) {
            this.ipsecPolicies().forEach(e -> e.validate());
        }
        if (this.trafficSelectorPolicies() != null) {
            this.trafficSelectorPolicies().forEach(e -> e.validate());
        }
    }
}

