/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteConnectionInner;
import com.azure.resourcemanager.network.models.ExpressRouteGatewayPropertiesAutoScaleConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualHubId;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ExpressRouteGatewayProperties {
    @JsonProperty(value="autoScaleConfiguration")
    private ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration;
    @JsonProperty(value="expressRouteConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<ExpressRouteConnectionInner> expressRouteConnections;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="virtualHub", required=true)
    private VirtualHubId virtualHub;
    private static final ClientLogger LOGGER = new ClientLogger(ExpressRouteGatewayProperties.class);

    public ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration() {
        return this.autoScaleConfiguration;
    }

    public ExpressRouteGatewayProperties withAutoScaleConfiguration(ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration) {
        this.autoScaleConfiguration = autoScaleConfiguration;
        return this;
    }

    public List<ExpressRouteConnectionInner> expressRouteConnections() {
        return this.expressRouteConnections;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public VirtualHubId virtualHub() {
        return this.virtualHub;
    }

    public ExpressRouteGatewayProperties withVirtualHub(VirtualHubId virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public void validate() {
        if (this.autoScaleConfiguration() != null) {
            this.autoScaleConfiguration().validate();
        }
        if (this.expressRouteConnections() != null) {
            this.expressRouteConnections().forEach(e -> e.validate());
        }
        if (this.virtualHub() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property virtualHub in model ExpressRouteGatewayProperties"));
        }
        this.virtualHub().validate();
    }
}

