/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.SecretProperties;
import java.io.IOException;
import java.util.Map;

public final class SecretCreateOrUpdateParameters
implements JsonSerializable<SecretCreateOrUpdateParameters> {
    private Map<String, String> tags;
    private SecretProperties properties;
    private static final ClientLogger LOGGER = new ClientLogger(SecretCreateOrUpdateParameters.class);

    public Map<String, String> tags() {
        return this.tags;
    }

    public SecretCreateOrUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public SecretProperties properties() {
        return this.properties;
    }

    public SecretCreateOrUpdateParameters withProperties(SecretProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model SecretCreateOrUpdateParameters"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SecretCreateOrUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SecretCreateOrUpdateParameters)jsonReader.readObject(reader -> {
            SecretCreateOrUpdateParameters deserializedSecretCreateOrUpdateParameters = new SecretCreateOrUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedSecretCreateOrUpdateParameters.properties = SecretProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSecretCreateOrUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretCreateOrUpdateParameters;
        });
    }
}

