/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.resourcemanager.iothub.models.EnrichmentProperties;
import com.azure.resourcemanager.iothub.models.FallbackRouteProperties;
import com.azure.resourcemanager.iothub.models.RouteProperties;
import com.azure.resourcemanager.iothub.models.RoutingEndpoints;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class RoutingProperties {
    @JsonProperty(value="endpoints")
    private RoutingEndpoints endpoints;
    @JsonProperty(value="routes")
    private List<RouteProperties> routes;
    @JsonProperty(value="fallbackRoute")
    private FallbackRouteProperties fallbackRoute;
    @JsonProperty(value="enrichments")
    private List<EnrichmentProperties> enrichments;

    public RoutingEndpoints endpoints() {
        return this.endpoints;
    }

    public RoutingProperties withEndpoints(RoutingEndpoints endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public List<RouteProperties> routes() {
        return this.routes;
    }

    public RoutingProperties withRoutes(List<RouteProperties> routes) {
        this.routes = routes;
        return this;
    }

    public FallbackRouteProperties fallbackRoute() {
        return this.fallbackRoute;
    }

    public RoutingProperties withFallbackRoute(FallbackRouteProperties fallbackRoute) {
        this.fallbackRoute = fallbackRoute;
        return this;
    }

    public List<EnrichmentProperties> enrichments() {
        return this.enrichments;
    }

    public RoutingProperties withEnrichments(List<EnrichmentProperties> enrichments) {
        this.enrichments = enrichments;
        return this;
    }

    public void validate() {
        if (this.endpoints() != null) {
            this.endpoints().validate();
        }
        if (this.routes() != null) {
            this.routes().forEach(e -> e.validate());
        }
        if (this.fallbackRoute() != null) {
            this.fallbackRoute().validate();
        }
        if (this.enrichments() != null) {
            this.enrichments().forEach(e -> e.validate());
        }
    }
}

