/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iothub.IotHubManager;
import com.azure.resourcemanager.iothub.fluent.ResourceProviderCommonsClient;
import com.azure.resourcemanager.iothub.fluent.models.UserSubscriptionQuotaListResultInner;
import com.azure.resourcemanager.iothub.implementation.UserSubscriptionQuotaListResultImpl;
import com.azure.resourcemanager.iothub.models.ResourceProviderCommons;
import com.azure.resourcemanager.iothub.models.UserSubscriptionQuotaListResult;

public final class ResourceProviderCommonsImpl
implements ResourceProviderCommons {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProviderCommonsImpl.class);
    private final ResourceProviderCommonsClient innerClient;
    private final IotHubManager serviceManager;

    public ResourceProviderCommonsImpl(ResourceProviderCommonsClient innerClient, IotHubManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<UserSubscriptionQuotaListResult> getSubscriptionQuotaWithResponse(Context context) {
        Response<UserSubscriptionQuotaListResultInner> inner = this.serviceClient().getSubscriptionQuotaWithResponse(context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new UserSubscriptionQuotaListResultImpl((UserSubscriptionQuotaListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public UserSubscriptionQuotaListResult getSubscriptionQuota() {
        UserSubscriptionQuotaListResultInner inner = this.serviceClient().getSubscriptionQuota();
        if (inner != null) {
            return new UserSubscriptionQuotaListResultImpl(inner, this.manager());
        }
        return null;
    }

    private ResourceProviderCommonsClient serviceClient() {
        return this.innerClient;
    }

    private IotHubManager manager() {
        return this.serviceManager;
    }
}

