/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iothub.IotHubManager;
import com.azure.resourcemanager.iothub.fluent.PrivateLinkResourcesOperationsClient;
import com.azure.resourcemanager.iothub.fluent.models.GroupIdInformationInner;
import com.azure.resourcemanager.iothub.fluent.models.PrivateLinkResourcesInner;
import com.azure.resourcemanager.iothub.implementation.GroupIdInformationImpl;
import com.azure.resourcemanager.iothub.implementation.PrivateLinkResourcesImpl;
import com.azure.resourcemanager.iothub.models.GroupIdInformation;
import com.azure.resourcemanager.iothub.models.PrivateLinkResources;
import com.azure.resourcemanager.iothub.models.PrivateLinkResourcesOperations;

public final class PrivateLinkResourcesOperationsImpl
implements PrivateLinkResourcesOperations {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkResourcesOperationsImpl.class);
    private final PrivateLinkResourcesOperationsClient innerClient;
    private final IotHubManager serviceManager;

    public PrivateLinkResourcesOperationsImpl(PrivateLinkResourcesOperationsClient innerClient, IotHubManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PrivateLinkResources> listWithResponse(String resourceGroupName, String resourceName, Context context) {
        Response<PrivateLinkResourcesInner> inner = this.serviceClient().listWithResponse(resourceGroupName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PrivateLinkResourcesImpl((PrivateLinkResourcesInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PrivateLinkResources list(String resourceGroupName, String resourceName) {
        PrivateLinkResourcesInner inner = this.serviceClient().list(resourceGroupName, resourceName);
        if (inner != null) {
            return new PrivateLinkResourcesImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<GroupIdInformation> getWithResponse(String resourceGroupName, String resourceName, String groupId, Context context) {
        Response<GroupIdInformationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, resourceName, groupId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GroupIdInformationImpl((GroupIdInformationInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GroupIdInformation get(String resourceGroupName, String resourceName, String groupId) {
        GroupIdInformationInner inner = this.serviceClient().get(resourceGroupName, resourceName, groupId);
        if (inner != null) {
            return new GroupIdInformationImpl(inner, this.manager());
        }
        return null;
    }

    private PrivateLinkResourcesOperationsClient serviceClient() {
        return this.innerClient;
    }

    private IotHubManager manager() {
        return this.serviceManager;
    }
}

